/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.web.filters.rewrite;

import com.ibm.bi.platform.commons.web.filters.rewrite.DelegatingServletContext;
import com.ibm.bi.platform.commons.web.filters.rewrite.NoopServletContext;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyLoadNamedServletContext
extends DelegatingServletContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyLoadNamedServletContext.class);
    private final String contextName;
    private final ServletContext originalContext;
    private boolean gotNamedContext = false;

    public LazyLoadNamedServletContext(ServletContext originalContext, String contextName) {
        super(null);
        this.originalContext = originalContext;
        this.contextName = contextName;
        if (!this.findNamedContext()) {
            LOGGER.info("named context {} not found, defaulting to Noop context", (Object)contextName);
            this.setDelegate(new NoopServletContext(contextName));
        }
    }

    private boolean findNamedContext() {
        ServletContext namedContext = this.originalContext.getContext(this.contextName);
        if (namedContext != null) {
            LOGGER.info("found context {}", (Object)this.contextName);
            this.setDelegate(namedContext);
            this.gotNamedContext = true;
        }
        return this.gotNamedContext;
    }

    @Override
    protected ServletContext getDelegate() {
        if (!this.gotNamedContext) {
            LOGGER.debug("attempt to use context {} that is missing or not yet loaded", (Object)this.contextName);
            this.findNamedContext();
        }
        return super.getDelegate();
    }
}

