<!-- Licensed Materials - Property of IBM

	IBM Cognos Products: Cognos Analytics

	(C) Copyright IBM Corp. 2017, 2022

	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
-->

<%@ page session="false" %>
<%@ page import="java.util.Date" %>
<%@ page import="com.ibm.bi.jsp.Utils" %>
<%@ page import="com.ibm.bi.webapp.utils.VersionUtils" %>
<%@ page import="org.apache.commons.lang.StringEscapeUtils"%>

<%
	request.setCharacterEncoding("utf-8");

	Date date = new Date();
	String currentTime = Long.toString(date.getTime());

	String authCode = StringEscapeUtils.escapeHtml(request.getParameter("code"));
	String authState = StringEscapeUtils.escapeHtml(request.getParameter("state"));

	String language = request.getLocale().toString().toLowerCase().replaceAll("_", "-");

	Boolean showLoadingIndicator = Boolean.getBoolean("loading.indicator");

	String version = VersionUtils.getInstance().getVersionTag();

	Boolean isIE = false;
	String userAgent = request.getHeader("user-agent");
	if ( userAgent != null && userAgent.matches("(.*)Trident/7(.*)")) {
			isIE = true;
	}
%>

<!DOCTYPE html>
<html lang="<%=language%>" dir="ltr" class="chrome" style="font-size:16px;">
	<head>
		<meta charset="utf-8">
		<meta content="images/logo_s.png" itemprop="image">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<meta name="msapplication-TileImage" content="images/logo_s.png">
		<meta name="msapplication-TileColor" content="#26A9E1">
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
		<script src="lib/requirejs/2.1.14/require.js"></script>
		<% if (isIE) { %>
		<script src="js/ba-polyfill.js?v=<%=version%>"></script>
		<% } %>
		<script>
		var clientLocale = '<%=language%>';
		var urlArgs = 'v=<%=version%>';
        </script>
		<script src="js/config.min.js?v=<%=version%>"></script>
		<script src="js/CompleteAuth.min.js?v=<%=version%>"></script>
		<% if (showLoadingIndicator) { %>
		<style id="ba-splash-styles">
			<jsp:include page="css/loading.css"/>
		</style>
		<% } %>
		<link href="lib/bootstrap/3.4.1/css/bootstrap.min.css" rel="stylesheet">
		<link href="css/glass/glass.min.css?v=<%=version%>" rel="stylesheet">
		<link rel="apple-touch-icon" href="v1/plugins/themes/current/favicon?v=<%=currentTime%>" class="themeressource">
		<link rel="icon" href="v1/plugins/themes/current/favicon?v=<%=currentTime%>" class="themeressource">
		<link rel="shortcut icon" href="v1/plugins/themes/current/favicon?v=<%=currentTime%>" class="themeressource">

		<script id="authCode" type="text/template"><%=authCode != null ? authCode : ""%></script>
		<script id="authState" type="text/template"><%=authState != null ? authState : "{}"%></script>

	</head>
	<body class="wireframe glass">
		<div id="main" class="pane"></div>
		<% if (showLoadingIndicator) { %>
			<jsp:include page="templates/loading.html"/>
		<% } %>
	</body>
</html>
