/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.json;

import com.ibm.bi.json.DefaultJsonFactory;
import com.ibm.bi.json.JsonNumber;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

public class JsonArray
extends ArrayList<Object> {
    private static final long serialVersionUID = -567029225443894168L;

    public JsonArray() {
    }

    public JsonArray(Object ... items) {
        super(items.length);
        for (Object item : items) {
            super.add(JsonObject.toJson(item));
        }
    }

    public JsonArray(Collection<?> items) {
        super(items.size());
        this.addAll(items);
    }

    public Boolean getBoolean(int index) {
        return (Boolean)super.get(index);
    }

    public Long getLong(int index) {
        return (Long)super.get(index);
    }

    public Double getDouble(int index) {
        return (Double)super.get(index);
    }

    public BigInteger getBigInteger(int index) {
        return (BigInteger)super.get(index);
    }

    public BigDecimal getBigDecimal(int index) {
        return (BigDecimal)super.get(index);
    }

    public JsonNumber getJsonNumber(int index) {
        Number v = this.getNumber(index);
        return v != null ? new JsonNumber(v) : null;
    }

    public Number getNumber(int index) {
        return (Number)super.get(index);
    }

    public String getString(int index) {
        return (String)super.get(index);
    }

    public JsonObject getObject(int index) {
        return (JsonObject)super.get(index);
    }

    public JsonArray getArray(int index) {
        return (JsonArray)super.get(index);
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, JsonObject.toJson(element));
    }

    @Override
    public boolean add(Object element) {
        return super.add(JsonObject.toJson(element));
    }

    @Override
    public Object set(int index, Object element) {
        return super.set(index, JsonObject.toJson(element));
    }

    @Override
    public boolean addAll(Collection<?> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (c.size() == 0) {
            return false;
        }
        super.addAll(index, c);
        if (!(c instanceof JsonArray)) {
            for (int i = index; i < c.size(); ++i) {
                Object newObj;
                Object oldObj = this.get(i);
                if (oldObj == (newObj = JsonObject.toJson(oldObj))) continue;
                super.set(i, newObj);
            }
        }
        return true;
    }

    public <T> ArrayList<T> items(Class<T> c) {
        return this;
    }

    public JsonArray addItem(Object item) {
        this.add(item);
        return this;
    }

    @Override
    public String toString() {
        JsonWriter json = new JsonWriter(false);
        StringWriter writer = new StringWriter();
        try {
            json.write(writer, (Object)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static JsonArray parseString(String s, boolean strict) throws IOException {
        return (JsonArray)DefaultJsonFactory.parseString(s, strict);
    }
}

