/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.crypto.internal.session;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.CamCryptoMessageKeys;
import com.ibm.bi.platform.commons.crypto.internal.session.SPSCipher;
import com.ibm.bi.platform.commons.crypto.internal.utils.IJVMEnvironment;
import com.ibm.bi.platform.commons.crypto.internal.utils.JcaFactory;
import com.ibm.bi.platform.commons.messages.Message;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SPSCipherAESjava
extends SPSCipher {
    public static final int TYPE = 4;
    private final IJVMEnvironment jvmEnv;
    private Integer seed = null;

    public SPSCipherAESjava(IJVMEnvironment theJvmEnv) {
        this.jvmEnv = theJvmEnv;
    }

    @Override
    protected SecretKeySpec createSecretKeySpec(byte[] rawKey) {
        return new SecretKeySpec(rawKey, 0, 16, "AES");
    }

    @Override
    protected Cipher getCipher() throws Exception {
        return Cipher.getInstance("AES", this.jvmEnv.getJCEProvider());
    }

    @Override
    protected byte[] getSystemKey() throws Exception {
        SKG systemKeyGenerator = new SKG(this.getSeed());
        return systemKeyGenerator.getHashedArray();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    protected byte[] addExtraData(byte[] cipherText) throws CAMCryptoException {
        byte[] extraData = new byte[]{(byte)(this.getSeed() & 0xFF), (byte)(this.getSeed() >> 8 & 0xFF), (byte)(this.getSeed() >> 16 & 0xFF), (byte)(this.getSeed() >> 24 & 0xFF)};
        byte[] data = new byte[cipherText.length + extraData.length];
        System.arraycopy(extraData, 0, data, 0, extraData.length);
        System.arraycopy(cipherText, 0, data, extraData.length, cipherText.length);
        return data;
    }

    @Override
    protected byte[] removeExtraData(byte[] data) throws Exception {
        if (data.length <= 4) {
            throw new CAMCryptoException(new Message(CamCryptoMessageKeys.syskey_gen_error));
        }
        byte[] cipherText = new byte[data.length - 4];
        int intSeed = 0;
        intSeed |= data[0] & 0xFF;
        intSeed |= data[1] << 8 & 0xFF00;
        intSeed |= data[2] << 16 & 0xFF0000;
        this.setSeed(intSeed |= data[3] << 24 & 0xFF000000);
        System.arraycopy(data, 4, cipherText, 0, data.length - 4);
        return cipherText;
    }

    private int getSeed() throws CAMCryptoException {
        if (this.seed == null) {
            this.seed = this.jvmEnv.getSecureRandom().nextInt();
        }
        return this.seed;
    }

    private void setSeed(int seed) {
        this.seed = seed;
    }

    private static class SKG {
        private int x;
        private static final int A = 1103515245;
        private static final int C = 12345;

        SKG(int seed) {
            this.x = seed;
        }

        int nextNumber() {
            this.x = 1103515245 * this.x + 12345;
            return this.x;
        }

        byte[] getHashedArray() throws JcaFactory.CouldNotGetInstanceException {
            int bytesPerInt = 4;
            int numBytes = 512;
            byte[] buffer = new byte[512];
            int byteIndex = 0;
            while (byteIndex < 512) {
                int number = this.nextNumber();
                for (int intIndex = 0; intIndex < 4 && byteIndex < 512; ++intIndex, ++byteIndex) {
                    buffer[byteIndex] = (byte)(number >> intIndex * 8 & 0xFF);
                }
            }
            MessageDigest md = JcaFactory.getInstance(MessageDigest.class, "SHA-256");
            return md.digest(buffer);
        }
    }
}

