/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import com.ibm.bi.soap.schema.DeserializationContext;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeHandler;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractType
implements Type {
    protected final String name;
    protected AbstractType base;
    protected Schema schema;
    protected boolean hasDerived;
    protected TypeHandler typeHandler;

    public AbstractType(String name) {
        this(name, null);
    }

    public AbstractType(String name, TypeHandler typeHandler) {
        this.name = name;
        this.typeHandler = typeHandler;
    }

    @Override
    public Type getBaseType() {
        return this.base;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalStateException("Schema redefinition.");
        }
        this.schema = schema;
    }

    @Override
    public void setBaseType(Type t) {
        if (!this.getClass().isInstance(t)) {
            throw new IllegalStateException("Invalid base type " + t.getName());
        }
        if (this.base != null) {
            throw new IllegalStateException("Base type redefinition.");
        }
        this.base = (AbstractType)t;
        this.base.hasDerived = true;
        this.typeHandler = this.base.typeHandler;
    }

    @Override
    public boolean hasDerived() {
        return this.hasDerived;
    }

    @Override
    public boolean isSubclassOf(Type base) {
        for (Type t = this; t != null; t = t.getBaseType()) {
            if (t != base) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setHandler(TypeHandler th) {
        this.typeHandler = th;
    }

    @Override
    public TypeHandler getHandler() {
        return this.typeHandler;
    }

    @Override
    public Object deserialize(DeserializationContext dc) throws XMLStreamException {
        return this.getHandler().deserialize(dc, this);
    }

    @Override
    public void serialize(SerializationContext sc, String tag, Object value) {
        this.getHandler().serialize(sc, tag, this, value);
    }
}

