/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.soap.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserCapabilitiesDecoder {
    private final String[] capabilities;

    public UserCapabilitiesDecoder(HashMap<String, Integer> capabilitiesBits) {
        int maxBit = capabilitiesBits.values().stream().max(Integer::compareTo).get();
        this.capabilities = new String[maxBit + 1];
        for (Map.Entry<String, Integer> entry : capabilitiesBits.entrySet()) {
            this.capabilities[entry.getValue().intValue()] = entry.getKey();
        }
    }

    public List<String> decode(String cookie) {
        int start;
        if (cookie == null || cookie.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int end = cookie.length() - 1;
        int wordOffset = 0;
        do {
            long word;
            if ((word = Long.parseLong(cookie.substring(start = cookie.lastIndexOf(59, end) + 1, end + 1), 16)) != 0L) {
                for (int bit = 0; bit < 32; ++bit) {
                    String s;
                    if ((word & (long)(1 << bit)) == 0L || wordOffset + bit >= this.capabilities.length || (s = this.capabilities[wordOffset + bit]) == null) continue;
                    result.add(s);
                }
            }
            wordOffset += 32;
        } while ((end = start - 2) >= 0);
        return result;
    }
}

