/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoKeyException;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.jni.JNIFileLock;
import com.cognos.accman.jcam.crypto.jni.JNISystemProperties;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.CMStoreWrapper;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IPFAuditFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceFunction;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.KeyExpiryChecker;
import com.cognos.accman.res.MessageSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class KeyStoreManager {
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    static IPFTraceLogger pkiTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.PKI");
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    private static KeyStoreManager singleton = null;
    private KeyStore cskKeyStore;
    private CAMKeyStore caKeyStore;
    private CAMKeyStore clientTrustStore;
    private CMStoreWrapper cmCSKStore;
    private CAMKeyStore caPublisherKeyStore;
    private boolean addedCACertificates = false;

    public static synchronized KeyStoreManager getInstance() {
        if (singleton == null) {
            singleton = new KeyStoreManager();
        }
        return singleton;
    }

    private KeyStoreManager() {
    }

    private boolean addCAPublishers() throws CAMCryptoException {
        caTraceLogger.logEnter();
        boolean addedTrustedCert = false;
        String jvmKeystoreFile = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        String jvmTrustStoreDefaultPassword = "changeit";
        try {
            Configuration config = Configuration.getInstance();
            String jvmTrustStorePassword = config.getJVMTrustStorePassword();
            if (jvmTrustStorePassword == null || jvmTrustStorePassword.length() == 0) {
                jvmTrustStorePassword = jvmTrustStoreDefaultPassword;
            }
            KeyStore jvmTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(jvmKeystoreFile);
            jvmTrustStore.load(fis, jvmTrustStorePassword.toCharArray());
            PKIXParameters pkixParams = new PKIXParameters(jvmTrustStore);
            for (TrustAnchor ta : pkixParams.getTrustAnchors()) {
                ECPublicKey ecPK;
                RSAPublicKey rsaPK;
                int keySize;
                PublicKey pk;
                String issuer;
                String subject;
                X509Certificate x509Cert = ta.getTrustedCert();
                String sigAlgName = x509Cert.getSigAlgName();
                if (sigAlgName.indexOf("MD5with") != -1 || sigAlgName.indexOf("MD2with") != -1 || sigAlgName.indexOf("SHA1with") != -1 && (subject = x509Cert.getSubjectDN().getName()).compareTo(issuer = x509Cert.getIssuerDN().getName()) != 0 || ((pk = x509Cert.getPublicKey()) instanceof RSAPublicKey ? (keySize = (rsaPK = (RSAPublicKey)pk).getModulus().bitLength()) < 2048 : !(pk instanceof ECPublicKey) || (keySize = (ecPK = (ECPublicKey)pk).getParams().getCurve().getField().getFieldSize()) < 224)) continue;
                boolean thisCertAdded = this.caKeyStore.addTrustedCert(x509Cert);
                addedTrustedCert = addedTrustedCert || thisCertAdded;
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            CAMCryptoKeyException cce = new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{jvmKeystoreFile}));
            pkiTraceLogger.logExit(cce);
            throw cce;
        }
        caTraceLogger.logExit(true);
        return addedTrustedCert;
    }

    private void addClientTrustCerts() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        String certsDir = config.getCertificateDirectory();
        if (certsDir == null) {
            return;
        }
        File dir = new File(certsDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".cer") || name.endsWith(".pem");
            }
        };
        String[] fileNames = dir.list(filter);
        if (fileNames != null) {
            String filename = null;
            try {
                for (int i = 0; i < fileNames.length; ++i) {
                    filename = fileNames[i];
                    caTraceLogger.trace("Add self-signed certificate" + filename);
                    Collection certs = CAMCryptoUtilities.getCertificatesFromFile(certsDir + "/" + filename);
                    if (certs == null || certs.isEmpty()) {
                        CAMCryptoKeyException ccke = new CAMCryptoKeyException(MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{filename}));
                        caTraceLogger.logExit(ccke);
                        throw ccke;
                    }
                    for (X509Certificate cert : certs) {
                        this.clientTrustStore.addTrustedCert(cert);
                    }
                }
            }
            catch (CAMCryptoException e) {
                CAMCryptoKeyException ccke = new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{filename}));
                caTraceLogger.logExit(ccke);
                throw ccke;
            }
        }
        caTraceLogger.logExit(true);
    }

    public Vector getCACertificates() throws CAMCryptoException {
        Certificate[] caCerts;
        List<Certificate> lCaCerts;
        caTraceLogger.logEnter();
        Vector<Certificate> vCACerts = null;
        if (this.caKeyStore == null) {
            boolean isForSSLTrustManager = false;
            this.setupCAKeystore("ca", isForSSLTrustManager);
        }
        if ((vCACerts = new Vector<Certificate>(lCaCerts = Arrays.asList(caCerts = this.caKeyStore.getAllCertificates()))) == null || vCACerts.size() == 0) {
            caTraceLogger.logExit();
        } else {
            caTraceLogger.logExit(true);
        }
        return vCACerts;
    }

    public CAMKeyStore getCAKeystore(String alias) throws CAMCryptoException {
        boolean isForSSLTrustManager = false;
        this.setupCAKeystore(alias, isForSSLTrustManager);
        return this.caKeyStore;
    }

    public CAMKeyStore getCAKeystoreForSSLTrustManager() throws CAMCryptoException {
        boolean isForSSLTrustManager = true;
        this.setupCAKeystore("ca", isForSSLTrustManager);
        return this.caKeyStore;
    }

    public Vector getCAPublishers() throws CAMCryptoException {
        Certificate[] pubCerts;
        List<Certificate> lPubCerts;
        caTraceLogger.logEnter();
        Vector<Certificate> vPubCerts = null;
        if (this.caPublisherKeyStore == null) {
            Configuration config = Configuration.getInstance();
            String publisherKeystoreLoc = config.getCATrustedPublisherKeyPairLocation();
            File publisherKeystore = new File(publisherKeystoreLoc);
            if (!publisherKeystore.exists()) {
                return null;
            }
            try {
                this.caPublisherKeyStore = new CAMKeyStore(publisherKeystoreLoc, config.getCATrustedPublisherPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
                this.caPublisherKeyStore.lock();
                this.caPublisherKeyStore.loadKeyStore();
            }
            catch (CAMCryptoException e) {
                CAMCryptoKeyException cce = new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{publisherKeystoreLoc}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            finally {
                if (this.caPublisherKeyStore != null) {
                    this.caPublisherKeyStore.unlock();
                }
            }
        }
        if ((vPubCerts = new Vector<Certificate>(lPubCerts = Arrays.asList(pubCerts = this.caPublisherKeyStore.getAllCertificates()))) == null || vPubCerts.size() == 0) {
            caTraceLogger.logExit();
        } else {
            caTraceLogger.logExit(true);
        }
        return vPubCerts;
    }

    public CAMKeyStore getClientTruststore() throws CAMCryptoException {
        this.setClientTruststore();
        return this.clientTrustStore;
    }

    public CMStoreWrapper getCMCSKStore() throws CAMCryptoException {
        this.setupCMCSKStore();
        return this.cmCSKStore;
    }

    public KeyStore getCSKKeystore() throws CAMCryptoException {
        this.setupCSKKeystore();
        return this.cskKeyStore;
    }

    public synchronized boolean isCAKeystoreValid() throws CAMCryptoException {
        caTraceLogger.logEnter();
        boolean retValue = false;
        Configuration config = Configuration.getInstance();
        int certSize = 0;
        if (this.caKeyStore == null) {
            try {
                this.caKeyStore = new CAMKeyStore(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
                this.caKeyStore.lock();
                this.caKeyStore.loadKeyStore();
                try {
                    certSize = this.caKeyStore.getKeyStore().size();
                    if (certSize != 0) {
                        retValue = true;
                    }
                }
                catch (KeyStoreException keyStoreException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.caKeyStore != null) {
                this.caKeyStore.unlock();
                this.caKeyStore = null;
            }
            caTraceLogger.logExit(retValue);
            return retValue;
        }
        caTraceLogger.logExit(true);
        return true;
    }

    public synchronized void reset() {
        this.cskKeyStore = null;
        this.caKeyStore = null;
        this.cmCSKStore = null;
    }

    public synchronized void resetcaKeyStore() {
        this.caKeyStore = null;
    }

    public synchronized void resetcmCSKStore() {
        this.cmCSKStore = null;
    }

    public synchronized void resetcskKeyStore() {
        this.cskKeyStore = null;
    }

    public synchronized void resetencKeyStore() {
    }

    public synchronized void resetsignKeyStore() {
    }

    private void sanitizeCAKeystore() throws CAMCryptoException {
        if (this.caKeyStore != null) {
            this.caKeyStore.sanitizeCerts();
        }
    }

    private synchronized void setClientTruststore() throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (this.clientTrustStore == null) {
            Configuration config = Configuration.getInstance();
            try {
                String format = config.getCAFormat();
                this.clientTrustStore = new CAMKeyStore("", config.getCAKeyPassword(), format, config.getAsymmKeystoreProviderName());
                this.clientTrustStore.loadKeyStore();
                this.addClientTrustCerts();
            }
            catch (CAMCryptoException cce) {
                this.clientTrustStore = null;
                caTraceLogger.logExit(cce);
                throw cce;
            }
            caTraceLogger.logExit(true);
        }
        caTraceLogger.logExit();
    }

    private synchronized void setupCAKeystore(String alias, boolean isForSSLTrustManager) throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        int certSize = 0;
        boolean addedTrustedCert = false;
        if (this.caKeyStore == null || !this.addedCACertificates && config.getWeAreTheConfigTool()) {
            try {
                this.caKeyStore = new CAMKeyStore(config.getCAMKeystoreLocation(), config.getCAKeyPassword(), config.getCAFormat(), config.getAsymmKeystoreProviderName());
                this.caKeyStore.lock();
                this.caKeyStore.loadKeyStore();
                try {
                    certSize = this.caKeyStore.getKeyStore().size();
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (config.getWeAreTheConfigTool()) {
                    addedTrustedCert = this.addCAPublishers();
                    this.addedCACertificates = true;
                }
            }
            catch (CAMCryptoException cce) {
                if (this.caKeyStore != null) {
                    this.caKeyStore.unlock();
                }
                this.caKeyStore = null;
                caTraceLogger.logExit(cce);
                throw cce;
            }
            catch (Exception e) {
                if (this.caKeyStore != null) {
                    this.caKeyStore.unlock();
                }
                this.caKeyStore = null;
                caTraceLogger.logExit(e);
                e.printStackTrace();
                throw new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCAMKeystoreLocation()}));
            }
            finally {
                if (this.caKeyStore != null) {
                    if ((certSize != 0 || addedTrustedCert) && config.getWeAreTheConfigTool()) {
                        this.sanitizeCAKeystore();
                        this.caKeyStore.saveKeyStore();
                    }
                    this.caKeyStore.unlock();
                }
            }
            if (0 == alias.compareToIgnoreCase("ca") && certSize != 0) {
                this.validateCACertificate(isForSSLTrustManager);
            }
            caTraceLogger.logExit(true);
        }
        caTraceLogger.logExit();
    }

    private synchronized void setupCMCSKStore() throws CAMCryptoException {
        if (this.cmCSKStore == null) {
            this.cmCSKStore = CMStoreWrapper.get();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void setupCSKKeystore() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        if (this.cskKeyStore == null) {
            FileOutputStream ksFos;
            FileInputStream ksStream;
            block22: {
                Configuration config = Configuration.getInstance();
                String jceksFilename = config.getCSKLocation();
                String bksFilename = jceksFilename + ".bks";
                String ksLockFilename = jceksFilename + ".lock";
                JNIFileLock fileLock = null;
                ksStream = null;
                ksFos = null;
                try {
                    StringBuffer sb = new StringBuffer();
                    fileLock = JNISystemProperties.lockFile((String)ksLockFilename, (StringBuffer)sb);
                    this.cskKeyStore = KeyStore.getInstance("BKS", "BC");
                    try {
                        ksStream = new FileInputStream(bksFilename);
                        this.cskKeyStore.load(ksStream, config.getCSKPassword().toCharArray());
                    }
                    catch (FileNotFoundException fnfe) {
                        try {
                            ksStream = new FileInputStream(jceksFilename);
                            KeyStore jceks = KeyStore.getInstance(config.getCSKFormat());
                            jceks.load(ksStream, config.getCSKPassword().toCharArray());
                            CAMCryptoUtilities.copyKeystore(jceks, this.cskKeyStore, config.getCSKPassword());
                            File fileObj = new File(bksFilename).getParentFile();
                            fileObj.mkdir();
                            ksFos = new FileOutputStream(bksFilename);
                            this.cskKeyStore.store(ksFos, config.getCSKPassword().toCharArray());
                        }
                        catch (FileNotFoundException fnfe2) {
                            this.cskKeyStore.load(null, config.getCSKPassword().toCharArray());
                        }
                    }
                    if (fileLock == null) break block22;
                }
                catch (IOException e) {
                    try {
                        this.cskKeyStore = null;
                        CAMCryptoKeyException cce = new CAMCryptoKeyException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
                        cskTraceLogger.logExit(cce);
                        throw cce;
                        catch (Exception e2) {
                            this.cskKeyStore = null;
                            CAMCryptoException cce2 = new CAMCryptoException(e2, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
                            cskTraceLogger.logExit(cce2);
                            throw cce2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fileLock != null) {
                            JNISystemProperties.unlockFile(fileLock);
                        }
                        if (ksStream != null) {
                            try {
                                ksStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (ksFos == null) throw throwable;
                        try {
                            ksFos.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                JNISystemProperties.unlockFile((JNIFileLock)fileLock);
            }
            if (ksStream != null) {
                try {
                    ksStream.close();
                }
                catch (IOException sb) {
                    // empty catch block
                }
            }
            if (ksFos != null) {
                try {
                    ksFos.close();
                }
                catch (IOException sb) {}
            }
        }
        cskTraceLogger.logExit(true);
    }

    private void validateCACertificate(boolean isForSSLTrustManager) throws CAMCryptoException {
        block10: {
            Configuration config = Configuration.getInstance();
            boolean isStandaloneCA = true;
            if (!isForSSLTrustManager) {
                isStandaloneCA = config.isStandaloneCA();
            }
            if (!config.getUsingThirdPartyCA() && isStandaloneCA) {
                try {
                    if (config.isCAKeyPairValid()) break block10;
                    try {
                        KeyExpiryChecker.checkForCAKeyExpiry();
                    }
                    catch (CAMCryptoException e) {
                        IPFTraceFunction.trace("Error checking CA rollover.");
                    }
                    try {
                        CaSyncHandler cash = CaSyncHandler.getInstance();
                        if (cash.isSameTrustRoot()) {
                            cash.synchronizeCaCerts();
                        }
                    }
                    catch (Exception e) {
                        IPFTraceFunction.trace("Error in checking same trust root and sync CA certificates.");
                    }
                }
                catch (CAMCryptoException e) {
                    if (config.getWeAreTheConfigTool() || config.getWeAreCFGAPI() || config.getWeAreIPF()) {
                        IPFAuditFunction.trace("Error checking CA rollover.Ignore if this is the first install running configuration toolfor first time");
                        return;
                    }
                    throw e;
                }
            }
        }
    }
}

