/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.WinkConfiguration;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceProvider
implements MessageBodyWriter<Source> {
    private static TransformerFactory transformerFactory;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static final Logger logger;

    protected boolean isReadable(MediaType mediaType) {
        return MediaTypeUtils.isXmlType(mediaType);
    }

    public long getSize(Source t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Source.class.isAssignableFrom(type) && MediaTypeUtils.isXmlType(mediaType);
    }

    public void writeTo(Source t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        StreamResult sr = new StreamResult(entityStream);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(t, sr);
        }
        catch (TransformerException e) {
            throw SourceProvider.asIOException(e);
        }
    }

    private static IOException asIOException(Exception e) throws IOException {
        IOException exception = new IOException();
        exception.initCause(e);
        return exception;
    }

    static {
        logger = LoggerFactory.getLogger(SourceProvider.class);
        transformerFactory = TransformerFactory.newInstance();
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class DOMSourceProvider
    extends SourceProvider
    implements MessageBodyReader<DOMSource> {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return DOMSource.class == type && super.isReadable(mediaType);
        }

        private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
            Properties props;
            RuntimeContext runtimeContext = RuntimeContextTLS.getRuntimeContext();
            WinkConfiguration winkConfig = runtimeContext.getAttribute(WinkConfiguration.class);
            if (winkConfig != null && (props = winkConfig.getProperties()) != null && Boolean.valueOf(props.getProperty("wink.supportDTDEntityExpansion")).booleanValue()) {
                return documentBuilderFactory.newDocumentBuilder();
            }
            try {
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                logger.error(e.getMessage());
            }
            try {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
            DocumentBuilder dbuilder = documentBuilderFactory.newDocumentBuilder();
            dbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String name, String baseURI) throws SAXException, IOException {
                    throw new SAXParseException(Messages.getMessage("entityRefsNotSupported"), null);
                }
            });
            return dbuilder;
        }

        public DOMSource readFrom(Class<DOMSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            try {
                DocumentBuilder dbuilder = this.getDocumentBuilder();
                return new DOMSource(dbuilder.parse(entityStream));
            }
            catch (NullPointerException npe) {
                StackTraceElement[] stackTraceElement = npe.getStackTrace();
                for (int i = 0; i < stackTraceElement.length; ++i) {
                    if (!stackTraceElement[i].getClassName().equals("com.sun.org.apache.xerces.internal.dom.DeferredDocumentImpl") || !stackTraceElement[i].getMethodName().equals("setChunkIndex")) continue;
                    logger.error(Messages.getMessage("entityRefsNotSupportedSunJDK5"), (Throwable)npe);
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
                throw npe;
            }
            catch (SAXException e) {
                logger.error(Messages.getMessage("saxParseException", type.getName()), (Throwable)e);
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
            catch (ParserConfigurationException e) {
                logger.error(Messages.getMessage("saxParserConfigurationException"), (Throwable)e);
                throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class SAXSourceProvider
    extends SourceProvider
    implements MessageBodyReader<SAXSource> {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return SAXSource.class == type && super.isReadable(mediaType);
        }

        public SAXSource readFrom(Class<SAXSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return new SAXSource(new InputSource(entityStream));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Provider
    @Consumes(value={"text/xml", "application/xml", "*/*"})
    @Produces(value={"text/xml", "application/xml", "*/*"})
    public static class StreamSourceProvider
    extends SourceProvider
    implements MessageBodyReader<Source> {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return type.isAssignableFrom(StreamSource.class) && super.isReadable(mediaType);
        }

        public StreamSource readFrom(Class<Source> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return new StreamSource(entityStream);
        }
    }
}

