/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderUtils {
    public static Locale languageToLocale(String language) {
        String[] languageSplit = language.split("-", 3);
        return new Locale(languageSplit[0].trim(), languageSplit.length > 1 ? languageSplit[1].trim() : "", languageSplit.length > 2 ? languageSplit[2].trim() : "");
    }

    public static String localeToLanguage(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer result = new StringBuffer(language);
        if (country != null && country.length() > 0) {
            result.append("-");
            result.append(country);
        }
        if (variant != null && variant.length() > 0) {
            result.append("-");
            result.append(variant);
        }
        return result.toString();
    }

    public static String buildOptionsHeader(Set<String> httpMethods) {
        if (httpMethods.contains("GET")) {
            httpMethods.add("HEAD");
        }
        httpMethods.add("OPTIONS");
        StringBuilder builder = new StringBuilder(30);
        String delimit = "";
        for (String httpMethod : httpMethods) {
            builder.append(delimit);
            builder.append(httpMethod);
            delimit = ", ";
        }
        return builder.toString();
    }
}

