/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.diagnostics.CCLCheck;
import com.cognos.ccl4j.exceptions.CCLException;
import com.cognos.ccl4j.exceptions.CCLNullArgumentException;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CCLXMLUtils {
    static final String ENCODED_QUOT = "&quot;";
    static final String ENCODED_AMP = "&amp;";
    static final String ENCODED_APOS = "&apos;";
    static final String ENCODED_LT = "&lt;";
    static final String ENCODED_GT = "&gt;";
    static final char ATTRIBUTE_ENCODE_DEFAULT_QUOTE_CHAR = '\"';
    public static final String XML_ERROR_PROP = "CCLXMLUTILS_XML_ERRORS";
    public static final String ATTR_TRUE = "true".intern();
    public static final String ATTR_FALSE = "false".intern();

    private CCLXMLUtils() {
    }

    public static final StringBuffer xmlEncode(String sToEncode, StringBuffer sbOutput) {
        StringBuffer sbRet = sbOutput;
        try {
            try {
                int nLen = sToEncode.length();
                if (sbRet == null) {
                    int nLenDoubled = nLen + nLen;
                    sbRet = new StringBuffer(nLenDoubled);
                }
                int nCurrentPos = 0;
                String sEncodedChar = null;
                int i = 0;
                for (i = 0; i < nLen; ++i) {
                    sEncodedChar = null;
                    char chIn = sToEncode.charAt(i);
                    if (chIn == '<') {
                        sEncodedChar = ENCODED_LT;
                    } else if (chIn == '>') {
                        sEncodedChar = ENCODED_GT;
                    } else if (chIn == '&') {
                        sEncodedChar = ENCODED_AMP;
                    }
                    if (sEncodedChar == null) continue;
                    sbRet.append(sToEncode.substring(nCurrentPos, i));
                    sbRet.append(sEncodedChar);
                    nCurrentPos = i + 1;
                }
                if (nCurrentPos < i) {
                    sbRet.append(sToEncode.substring(nCurrentPos, i));
                }
            }
            catch (NullPointerException npex) {
                if (sToEncode == null) {
                    throw new CCLNullArgumentException("NULL String PARAMETER");
                }
                throw npex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "encoding string '" + sToEncode + "' to StringBuffer");
        }
        return sbRet;
    }

    public static final void xmlEncode(String sToEncode, Writer wrOutput) {
        try {
            try {
                int nCurrentPos = 0;
                String sEncodedChar = null;
                int nLen = sToEncode.length();
                int i = 0;
                for (i = 0; i < nLen; ++i) {
                    sEncodedChar = null;
                    char chIn = sToEncode.charAt(i);
                    if (chIn == '<') {
                        sEncodedChar = ENCODED_LT;
                    } else if (chIn == '>') {
                        sEncodedChar = ENCODED_GT;
                    } else if (chIn == '&') {
                        sEncodedChar = ENCODED_AMP;
                    }
                    if (sEncodedChar == null) continue;
                    wrOutput.write(sToEncode.substring(nCurrentPos, i));
                    wrOutput.write(sEncodedChar);
                    nCurrentPos = i + 1;
                }
                if (nCurrentPos < i) {
                    wrOutput.write(sToEncode.substring(nCurrentPos, i));
                }
            }
            catch (NullPointerException npex) {
                if (sToEncode == null) {
                    throw new CCLNullArgumentException("NULL String PARAMETER");
                }
                if (wrOutput == null) {
                    throw new CCLNullArgumentException("NULL Writer PARAMETER");
                }
                throw npex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "encoding string '" + sToEncode + "' to Writer");
        }
    }

    public static final String xmlEncode(String sToEncode) {
        StringBuffer sb = CCLXMLUtils.xmlEncode(sToEncode, (StringBuffer)null);
        String sRet = sb.toString();
        return sRet;
    }

    public static final StringBuffer attributeEncode(String sToEncode, StringBuffer sb) {
        return CCLXMLUtils.attributeEncode(sToEncode, sb, false);
    }

    public static final StringBuffer attributeEncode_addQuotes(String sToEncode, StringBuffer sbOutput) {
        return CCLXMLUtils.attributeEncode(sToEncode, sbOutput, true);
    }

    static final StringBuffer attributeEncode(String sToEncode, StringBuffer sbOutput, boolean bAddQuotes) {
        StringBuffer sbRet = sbOutput;
        try {
            try {
                int nLen = sToEncode.length();
                if (sbRet == null) {
                    int nLenDoubled = nLen + nLen;
                    sbRet = new StringBuffer(nLenDoubled);
                }
                if (bAddQuotes) {
                    sbRet.append('\"');
                }
                int nCurrentPos = 0;
                String sEncodedChar = null;
                int i = 0;
                for (i = 0; i < nLen; ++i) {
                    sEncodedChar = null;
                    char chIn = sToEncode.charAt(i);
                    if (chIn == '\'') {
                        sEncodedChar = ENCODED_APOS;
                    } else if (chIn == '\"') {
                        sEncodedChar = ENCODED_QUOT;
                    } else if (chIn == '&') {
                        sEncodedChar = ENCODED_AMP;
                    }
                    if (sEncodedChar == null) continue;
                    sbRet.append(sToEncode.substring(nCurrentPos, i));
                    sbRet.append(sEncodedChar);
                    nCurrentPos = i + 1;
                }
                if (nCurrentPos < i) {
                    sbRet.append(sToEncode.substring(nCurrentPos, i));
                }
                if (bAddQuotes) {
                    sbRet.append('\"');
                }
            }
            catch (NullPointerException npex) {
                if (sToEncode == null) {
                    throw new CCLNullArgumentException("NULL String PARAMETER");
                }
                throw npex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "encoding attribute string '" + sToEncode + "' to StringBuffer");
        }
        return sbRet;
    }

    public static final void attributeEncode(String sToEncode, Writer wrOutput) {
        CCLXMLUtils.attributeEncode(sToEncode, wrOutput, false);
    }

    public static final void attributeEncode_addQuotes(String sToEncode, Writer wrOutput) {
        CCLXMLUtils.attributeEncode(sToEncode, wrOutput, true);
    }

    static final void attributeEncode(String sToEncode, Writer wrOutput, boolean bAddQuotes) {
        try {
            try {
                if (bAddQuotes) {
                    wrOutput.write(34);
                }
                int nLen = sToEncode.length();
                int nCurrentPos = 0;
                String sEncodedChar = null;
                int i = 0;
                for (i = 0; i < nLen; ++i) {
                    sEncodedChar = null;
                    char chIn = sToEncode.charAt(i);
                    if (chIn == '\'') {
                        sEncodedChar = ENCODED_APOS;
                    } else if (chIn == '\"') {
                        sEncodedChar = ENCODED_QUOT;
                    } else if (chIn == '&') {
                        sEncodedChar = ENCODED_AMP;
                    }
                    if (sEncodedChar == null) continue;
                    wrOutput.write(sToEncode.substring(nCurrentPos, i));
                    wrOutput.write(sEncodedChar);
                    nCurrentPos = i + 1;
                }
                if (nCurrentPos < i) {
                    wrOutput.write(sToEncode.substring(nCurrentPos, i));
                }
                if (bAddQuotes) {
                    wrOutput.write(34);
                }
            }
            catch (NullPointerException npex) {
                if (sToEncode == null) {
                    throw new CCLNullArgumentException("NULL String PARAMETER");
                }
                if (wrOutput == null) {
                    throw new CCLNullArgumentException("NULL Writer PARAMETER");
                }
                throw npex;
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "encoding attr string '" + sToEncode + "' to Writer");
        }
    }

    public static final String attributeEncode(String sToEncode) {
        StringBuffer sb = CCLXMLUtils.attributeEncode(sToEncode, (StringBuffer)null, false);
        String sRet = sb.toString();
        return sRet;
    }

    public static final String attributeEncode_addQuotes(String sToEncode) {
        StringBuffer sb = CCLXMLUtils.attributeEncode(sToEncode, (StringBuffer)null, true);
        String sRet = sb.toString();
        return sRet;
    }

    static final String attributeEncode(String sToEncode, boolean bAddQuotes) {
        StringBuffer sb = CCLXMLUtils.attributeEncode(sToEncode, (StringBuffer)null, bAddQuotes);
        String sRet = sb.toString();
        return sRet;
    }

    public static Document buildDOM(InputStream is) {
        Document docRet = null;
        XMLErrors errors = null;
        try {
            SAXReader reader = new SAXReader();
            docRet = reader.read(is);
            errors = new XMLErrors();
            reader.setErrorHandler((ErrorHandler)errors);
        }
        catch (DocumentException dex) {
            String sErrorSection = "";
            CCLRuntimeException cclrex = new CCLRuntimeException(dex, "building DOM from InputStream." + sErrorSection);
            cclrex.setProperty(XML_ERROR_PROP, errors);
            throw cclrex;
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "building DOM from input-stream");
        }
        return docRet;
    }

    public static final boolean parseBooleanAttribute(String strValue) throws InvalidBooleanValueException {
        CCLCheck.validString(strValue);
        if (strValue == ATTR_TRUE) {
            return true;
        }
        if (strValue == ATTR_FALSE) {
            return false;
        }
        if (strValue.equals(ATTR_TRUE)) {
            return true;
        }
        if (strValue.equals(ATTR_FALSE)) {
            return false;
        }
        if (strValue.equalsIgnoreCase(ATTR_TRUE) || strValue.equalsIgnoreCase("t") || strValue.equals("1") || strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("y") || strValue.equalsIgnoreCase("on")) {
            return true;
        }
        if (strValue.equalsIgnoreCase(ATTR_FALSE) || strValue.equalsIgnoreCase("f") || strValue.equals("0") || strValue.equalsIgnoreCase("no") || strValue.equalsIgnoreCase("n") || strValue.equalsIgnoreCase("off")) {
            return false;
        }
        throw new InvalidBooleanValueException(strValue);
    }

    public static final String getBooleanString(boolean b) {
        if (b) {
            return ATTR_TRUE;
        }
        return ATTR_FALSE;
    }

    public static class InvalidBooleanValueException
    extends CCLException {
        public InvalidBooleanValueException(String sMsg) {
            super(sMsg);
        }
    }

    public static class XMLErrors
    implements ErrorHandler {
        ArrayList _vErrors = null;

        @Override
        public void warning(SAXParseException ex) {
            this.store(ex, "Warning");
        }

        @Override
        public void error(SAXParseException ex) {
            this.store(ex, "Error");
        }

        @Override
        public void fatalError(SAXParseException ex) {
            this.store(ex, "Fatal Error");
        }

        private void store(SAXParseException ex, String type) {
            String sErrorMsg = type + " at line number " + ex.getLineNumber() + ": " + ex.getMessage();
            if (this._vErrors == null) {
                this._vErrors = new ArrayList();
            }
            this._vErrors.add(sErrorMsg);
        }

        public String toString() {
            String sRet = "";
            StringBuffer sb = new StringBuffer(1024);
            for (int i = 0; i < this._vErrors.size(); ++i) {
                if (i > 0) {
                    sb.append(" -- ");
                }
                String sMsg = (String)this._vErrors.get(i);
                sb.append(sMsg);
            }
            return sRet;
        }
    }
}

