/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccl4j.message;

import com.ibm.cognos.ccl4j.message.CCLUntranslatedMessages;
import com.ibm.cognos.ccl4j.message.ICCLMessageTemplate;
import com.ibm.cognos.ccl4j.message.ICCLTranslatedMessages;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CCLMessagesFromResourceBundle
implements ICCLTranslatedMessages {
    private final String messageBundleName;
    private static Locale msgLocale;
    private ResourceBundle bundle = null;

    public CCLMessagesFromResourceBundle(String bundleName, Locale locale) {
        msgLocale = locale;
        this.messageBundleName = bundleName;
    }

    public CCLMessagesFromResourceBundle(String bundleName, String locale) throws Exception {
        CCLMessagesFromResourceBundle.setLocale(locale);
        this.messageBundleName = bundleName;
    }

    public CCLMessagesFromResourceBundle(String bundleName) {
        CCLMessagesFromResourceBundle.setLocale(null);
        this.messageBundleName = bundleName;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setLocale(String strLocale) {
        msgLocale = null;
        String sLanguage = null;
        String sCountry = null;
        if (strLocale == null || strLocale.length() == 0) {
            msgLocale = Locale.getDefault();
            return;
        }
        if (strLocale.length() > 2) {
            int langSep = strLocale.indexOf("-");
            if (langSep < 2) {
                msgLocale = Locale.getDefault();
                return;
            }
            sCountry = strLocale.substring(langSep + 1);
            sLanguage = strLocale.substring(0, langSep);
        } else {
            sLanguage = strLocale;
        }
        if (sCountry != null && sCountry.length() != 0) {
            msgLocale = new Locale(sLanguage, sCountry);
            return;
        }
        msgLocale = new Locale(sLanguage);
    }

    @Override
    public Locale getLocale() {
        return msgLocale;
    }

    @Override
    public String getString(ICCLMessageTemplate messageTemplate) {
        try {
            return messageTemplate.apply(this.getBundle());
        }
        catch (Exception ex) {
            CCLUntranslatedMessages messageSource = new CCLUntranslatedMessages();
            return messageSource.getString(messageTemplate);
        }
    }

    private synchronized ResourceBundle getBundle() {
        if (this.bundle == null) {
            if (msgLocale != null) {
                try {
                    this.bundle = ResourceBundle.getBundle(this.messageBundleName, msgLocale);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            if (this.bundle == null) {
                try {
                    this.bundle = ResourceBundle.getBundle(this.messageBundleName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.bundle;
    }
}

