/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.ccl4j.xss;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.io.UnsupportedEncodingException;

public class XSSEncoder {
    private static final String XSS_START = "XSSSTART";
    private static final String XSS_END = "XSSEND";
    private static final byte[] m_HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static byte[] m_tpXSSChars = XSSEncoder.initializeXXSChars();
    private static final int MAX_XSS_LENGTH = 256;
    private static byte[] m_XSSCharsTable = XSSEncoder.initializeXSSCharsTable();

    private static byte[] initializeXXSChars() {
        byte[] temp = null;
        try {
            temp = new String("<'>").getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return temp;
    }

    private static byte[] initializeXSSCharsTable() {
        byte[] temp = new byte[256];
        for (int i = 0; i < 256; ++i) {
            temp[i] = 0;
        }
        for (int j = 0; j < m_tpXSSChars.length; ++j) {
            temp[XSSEncoder.m_tpXSSChars[j]] = 1;
        }
        return temp;
    }

    public static String tpXSSEncode(String getData) throws CCLRuntimeException {
        if (getData == null) {
            throw new CCLRuntimeException("The input string to XSS Encode is null.");
        }
        String res = getData;
        if (getData.indexOf(37) != -1 || XSSEncoder.containsXSSChar(getData, null)) {
            res = XSSEncoder.wrapAndXSSEncode(getData);
        }
        return res;
    }

    public static String wrapAndXSSEncode(String str) {
        StringBuffer xssBuf = new StringBuffer(4096);
        xssBuf.setLength(0);
        xssBuf.append(XSS_START);
        XSSEncoder.optimizedEncodeXSS(str, xssBuf);
        xssBuf.append(XSS_END);
        return xssBuf.toString();
    }

    private static void optimizedEncodeXSS(String queryString, StringBuffer outBuf) {
        char[] arrChar = queryString.toCharArray();
        char c = '\u0000';
        int tempbuflookahead = 16;
        int tempbuflen = queryString.length() * 2;
        char[] tempbuf = new char[tempbuflen + 16];
        int tempbufidx = -1;
        for (int i = 0; i < arrChar.length; ++i) {
            c = arrChar[i];
            if (c == '%') {
                tempbuf[++tempbufidx] = 42;
            } else if (c == '*') {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = 50;
                tempbuf[++tempbufidx] = 97;
            } else if (c == '_') {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = 53;
                tempbuf[++tempbufidx] = 102;
            } else if ((c & 0xFF00) == 0 && m_XSSCharsTable[c] == 1) {
                tempbuf[++tempbufidx] = 95;
                tempbuf[++tempbufidx] = (char)m_HEX_CHARS[(c & 0xF0) >> 4];
                tempbuf[++tempbufidx] = (char)m_HEX_CHARS[c & 0xF];
            } else {
                tempbuf[++tempbufidx] = c;
            }
            if (tempbufidx < tempbuflen) continue;
            outBuf.append(tempbuf, 0, tempbufidx + 1);
            tempbufidx = -1;
        }
        if (tempbufidx >= 0) {
            outBuf.append(tempbuf, 0, tempbufidx + 1);
        }
    }

    public static boolean containsXSSChar(String str, StringBuffer invalidChar) {
        for (int i = 0; i < m_tpXSSChars.length; ++i) {
            if (str.indexOf(m_tpXSSChars[i]) == -1) continue;
            if (invalidChar != null) {
                invalidChar.setLength(0);
                invalidChar.append((char)m_tpXSSChars[i]);
            }
            return true;
        }
        return false;
    }
}

