/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.indications.internal;

import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import org.apache.commons.lang.StringUtils;

public class AuditLoggerNameResolver {
    private static final String[] stdStr = new String[]{"Audit.RTUsage.", "Audit.Admin.", "Audit.Other.", "Audit."};

    public static ServiceLoggerName resolveName(String name) {
        if (name.equals("Audit") || !name.startsWith("Audit")) {
            return new ServiceLoggerName(name, "");
        }
        String suffix = null;
        String stdPrefix = null;
        for (String prefix : stdStr) {
            if (!name.startsWith(prefix)) continue;
            stdPrefix = prefix;
            suffix = name.substring(prefix.length());
            break;
        }
        if (stdPrefix == null) {
            return new ServiceLoggerName(name, null);
        }
        int firstDot = suffix.indexOf(".");
        String componentName = -1 == firstDot ? suffix : suffix.substring(0, firstDot);
        String serviceName = LogIPFConfigure.getServiceName(componentName);
        if (StringUtils.isEmpty((String)serviceName)) {
            return new ServiceLoggerName(name, null);
        }
        String loggerName = -1 == serviceName.indexOf(59) ? stdPrefix + serviceName + "." + suffix : name;
        LogIPFLog.debug("resolveName('" + name + "') to:  loggername='" + loggerName + "', servicename='" + serviceName + "'\n");
        return new ServiceLoggerName(loggerName, serviceName);
    }

    public static String[] getStdStr() {
        return stdStr;
    }

    public static class ServiceLoggerName {
        private final String loggerName;
        private final String serviceName;

        public ServiceLoggerName(String loggerName, String serviceName) {
            this.loggerName = loggerName;
            this.serviceName = serviceName;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

