/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config;

import com.ibm.bi.config.setup.ArchaiusSetup;
import com.ibm.bi.config.setup.CogLocaleConfiguration;
import com.ibm.bi.config.setup.CogstartupConfiguration;
import com.ibm.bi.config.setup.PredefinedConfiguration;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CogStartupTransfer {
    private static final Logger log = LoggerFactory.getLogger(CogStartupTransfer.class);
    private static String CONFIG_APACHEDSPORT = "Configuration.ApacheDSPort";
    private static String CONFIG_LEGACYLAUNCHABLE = "Configuration.LegacyLaunchable";
    private ArrayList<String> predefinedGlobalSettings;
    private ArchaiusSetup archaiusSetup;
    private PropertiesConfiguration installDataProperties;

    public CogStartupTransfer(ArchaiusSetup archaiusSetup) {
        this.archaiusSetup = archaiusSetup;
        this.initialize();
    }

    protected void initialize() {
        this.installDataProperties = null;
        this.predefinedGlobalSettings = this.getPredGlobalSettings(this.archaiusSetup.getPredefinedConfiguration());
    }

    private ArrayList<String> getPredGlobalSettings(ArrayList<PredefinedConfiguration> predConfigList) {
        ArrayList<String> globalSettings = new ArrayList<String>();
        if (predConfigList != null) {
            for (PredefinedConfiguration predConfig : predConfigList) {
                if (predConfig == null || predConfig.getGlobalSettings().size() <= 0) continue;
                globalSettings.addAll(predConfig.getGlobalSettings());
            }
        }
        return globalSettings;
    }

    public PropertiesConfiguration scrapeGlobalSettings() {
        if (ConfigurationUtils.isCMEnabled()) {
            try {
                CogstartupConfiguration cogstartupConfig = this.archaiusSetup.getCogStartupConfig();
                CogLocaleConfiguration coglocaleConfig = this.archaiusSetup.getCogLocaleConfig();
                return this.extractGlobalSettings(cogstartupConfig, coglocaleConfig);
            }
            catch (ConfigurationException e) {
                log.warn("Unable to scrape global settings. " + e.getMessage());
                log.debug("exception details:", (Throwable)e);
            }
        }
        return null;
    }

    private PropertiesConfiguration extractGlobalSettings(CogstartupConfiguration cogstartupConfig, CogLocaleConfiguration coglocaleConfig) {
        log.debug("start extracting global settings");
        PropertiesConfiguration settings = PropertiesConfigurationFactory.make();
        if (coglocaleConfig != null) {
            coglocaleConfig.processGlobalLocaleSettings(this.predefinedGlobalSettings);
        }
        if (cogstartupConfig != null && coglocaleConfig != null) {
            for (String key : this.predefinedGlobalSettings) {
                String value = (String)cogstartupConfig.getProperty(key);
                if (value != null) {
                    String nosenskey = this.archaiusSetup.getNonSensitiveFullKeyname(key);
                    if (!nosenskey.equals(key)) {
                        String nosensvalue = (String)cogstartupConfig.getProperty(nosenskey);
                        settings.setProperty(nosenskey, (Object)nosensvalue);
                    }
                } else {
                    value = (String)coglocaleConfig.getProperty(key);
                }
                if (value == null) {
                    settings.clearProperty(key);
                    continue;
                }
                settings.setProperty(key, (Object)value);
            }
        } else {
            log.error("The cogstartup or coglocale configuration is null. Unable to grab global settings.");
        }
        try {
            this.setGlobalSettingsFromInstallDataProp(settings);
        }
        catch (Exception e) {
            log.warn("Unable to get global configuration from installData.properties file. " + e.getMessage());
            log.debug("exception details:", (Throwable)e);
        }
        log.debug("finished extracting global settings");
        return settings;
    }

    private void setGlobalSettingsFromInstallDataProp(PropertiesConfiguration settings) throws Exception {
        PropertiesConfiguration installDataProp = this.getInstallDataProp();
        if (installDataProp != null) {
            int apacheDSPort = 0;
            if (installDataProp.containsKey(CONFIG_APACHEDSPORT)) {
                apacheDSPort = installDataProp.getInt(CONFIG_APACHEDSPORT);
            }
            if (apacheDSPort > 0) {
                log.info("setting {} to {}", (Object)CONFIG_APACHEDSPORT, (Object)apacheDSPort);
                settings.setProperty(CONFIG_APACHEDSPORT, (Object)apacheDSPort);
            }
            if (installDataProp.containsKey(CONFIG_LEGACYLAUNCHABLE)) {
                String legacyLaunchable = installDataProp.getString(CONFIG_LEGACYLAUNCHABLE);
                log.info("setting {} to {}", (Object)CONFIG_LEGACYLAUNCHABLE, (Object)legacyLaunchable);
                settings.setProperty(CONFIG_LEGACYLAUNCHABLE, (Object)legacyLaunchable);
            }
        }
    }

    public PropertiesConfiguration getInstallDataProp() throws Exception {
        if (this.installDataProperties != null) {
            return this.installDataProperties;
        }
        String absPath = ConfigurationUtils.resolvePath((String)"configuration/installData.properties");
        File installProp = new File(absPath);
        if (installProp.exists()) {
            this.installDataProperties = PropertiesConfigurationFactory.make();
            this.installDataProperties.load(installProp);
            return this.installDataProperties;
        }
        return this.installDataProperties;
    }
}

