/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config;

import com.ibm.bi.config.ConfigConstants;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.FlipperConfigurationImpl;
import com.ibm.bi.config.IConfiguration;
import com.ibm.bi.config.acl.AccessDefinition;
import com.ibm.bi.config.external.DecodedKeyFactory;
import com.ibm.bi.config.external.flipper.FlipperRESTFactory;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.ibm.bi.config.metadata.CategoryDefinition;
import com.ibm.bi.config.startupbridge.StartupXML;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.netflix.config.DynamicStringProperty;
import java.io.File;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactory
extends ConfigConstants {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static IConfiguration _instance = null;
    private static CategoryDefinition _metaInstance = null;
    private static AccessDefinition _aclDefInstance = null;

    public static synchronized IConfiguration getInstance() {
        if (null == _instance) {
            FlipperRestInterface flipperRest = FlipperRESTFactory.getInstance().getFlipperRest();
            _instance = new FlipperConfigurationImpl(ConfigurationFactory.makeDecodedKeyFactory(), flipperRest);
            if (ConfigurationUtils.runningWithP2PD()) {
                LOG.info("Start monitoring global settings from P2PD dispatcher.");
                ConfigurationFactory.monitorGlobalSettings();
            }
            ConfigurationFactory.monitorAAA();
        }
        return _instance;
    }

    public static void monitorAAA() {
        if (ConfigurationUtils.isCMEnabled() && ConfigurationUtils.isDynamicNamespaceEnabled()) {
            LOG.info("Start monitoring AAA settings. When AAA is changed, we should update cogstarutp.xml on this node.");
            ConfigurationFactory.monitorGlobalAAASettings();
        }
    }

    public static synchronized CategoryDefinition getMetaInstance() {
        if (null == _metaInstance) {
            _metaInstance = ConfigurationFactory.initConfigDefinition();
        }
        return _metaInstance;
    }

    private static CategoryDefinition initConfigDefinition() {
        CategoryDefinition categoryDef = null;
        File file = new File(ConfigurationUtils.resolvePath((String)"configuration/metadata/xml/category_definition.xml"));
        if (file.exists()) {
            try {
                categoryDef = new CategoryDefinition(ConfigurationUtils.resolvePath((String)"configuration/metadata/xml/category_definition.xml"));
            }
            catch (ConfigurationException e) {
                LOG.error("Unable to create CategoryDefinition", (Object)e.getLocalizedMessage());
            }
        } else {
            LOG.error("file configuration/metadata/xml/category_definition.xml not found");
        }
        return categoryDef;
    }

    public static synchronized AccessDefinition getAccessDefInstance() {
        if (null == _aclDefInstance) {
            _aclDefInstance = ConfigurationFactory.initACLDefinition();
        }
        return _aclDefInstance;
    }

    private static AccessDefinition initACLDefinition() {
        AccessDefinition accessDef = null;
        String absolutePath = ConfigurationUtils.resolvePath((String)"configuration/configACLDef.json");
        File file = new File(absolutePath);
        if (file.exists()) {
            accessDef = new AccessDefinition(absolutePath);
        } else {
            accessDef = new AccessDefinition();
            accessDef.setAccessCheckStatus(false);
        }
        return accessDef;
    }

    static DecodedKeyFactory makeDecodedKeyFactory() {
        DecodedKeyFactory decodedKeyFactory = new DecodedKeyFactory();
        try {
            decodedKeyFactory.setLocalPath(ConfigurationFactory.getLocalPath());
        }
        catch (Exception e) {
            LOG.error("makeDecodedKeyFactory() invalid local Uri ", (Throwable)e);
        }
        return decodedKeyFactory;
    }

    static String getLocalPath() throws Exception {
        String localpath = "";
        String host = "localhost";
        int port = 9300;
        URI uri = null;
        ConfigurationPropertyFactory cpf = ConfigurationPropertyFactory.getInstance();
        String externalDispatcher = cpf.getArchaiusSetup().getCogStartupConfig().getString("externalDispatcher");
        if (externalDispatcher != null) {
            uri = new URI(externalDispatcher);
        } else if (ConfigurationUtils.runningOnCloud()) {
            String wsURI = cpf.getArchaiusSetup().getCogStartupConfig().getString("webServiceURI");
            uri = new URI(wsURI);
        }
        if (uri != null) {
            host = uri.getHost();
            port = uri.getPort();
        }
        localpath = host + "_" + port;
        return localpath;
    }

    static String getHostName() {
        return ConfigurationUtils.getFlipperhost();
    }

    static void monitorGlobalSettings() {
        DynamicStringProperty stringProperty = ConfigurationPropertyFactory.getInstance().getStringProperty("contentManager", "");
        stringProperty.addCallback(new Runnable(){

            @Override
            public void run() {
                DynamicStringProperty cmurlProperty = ConfigurationPropertyFactory.getInstance().getStringProperty("contentManager", "");
                LOG.info("monitorGlobalSettings - active cm url is updated: contentManager=" + cmurlProperty.get());
                if (_instance != null) {
                    ArrayList<Map.Entry<String, String>> pairs = new ArrayList<Map.Entry<String, String>>();
                    pairs.add(new AbstractMap.SimpleEntry<String, String>("contentManager", cmurlProperty.get()));
                    try {
                        LOG.info("monitorGlobalSettings - update 'contentManager' to flipper configuration0.properties.");
                        _instance.putMany("global", pairs);
                    }
                    catch (Exception e) {
                        LOG.error("monitorGlobalSettings: throw exception when update flipper - " + e.getMessage());
                    }
                }
            }
        });
    }

    static void monitorGlobalAAASettings() {
        DynamicStringProperty providerProperty = ConfigurationPropertyFactory.getInstance().getStringProperty("AAA.global", "");
        LOG.info("monitorGlobalAAASettings - initial AAA.global = {}", (Object)providerProperty.get());
        providerProperty.addCallback(new Runnable(){

            @Override
            public void run() {
                LOG.info("monitorGlobalAAASettings - AAA.global settings are updated, the call back is triggered.");
                DynamicStringProperty aaaconfigProperty = ConfigurationPropertyFactory.getInstance().getStringProperty("AAA.global", "");
                if (aaaconfigProperty != null) {
                    String configstring = aaaconfigProperty.get();
                    LOG.info("monitorGlobalAAASettings - updated AAA.global = {}", (Object)configstring);
                    StartupXML.getInstance().updateCogStartup("AAA", configstring);
                }
            }
        });
    }
}

