/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config;

import com.google.common.collect.Lists;
import com.ibm.bi.config.CogStartupTransfer;
import com.ibm.bi.config.ConfigConstants;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.IConfiguration;
import com.ibm.bi.config.RequestContext;
import com.ibm.bi.config.external.CheckedInputStreamFilter;
import com.ibm.bi.config.external.DecodedKey;
import com.ibm.bi.config.external.DecodedKeyFactory;
import com.ibm.bi.config.external.PropertiesReader;
import com.ibm.bi.config.external.flipper.ConfigHolder;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.ibm.bi.config.external.flipper.LiveProperties;
import com.ibm.bi.config.migration.ConfigurationMigrationHelper;
import com.ibm.bi.config.setup.ArchaiusSetup;
import com.ibm.bi.config.startupbridge.StartupXML;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlipperConfigurationImpl
extends ConfigConstants
implements IConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(FlipperConfigurationImpl.class);
    public static final int GLOBAL_READWRITE_LAYER = 0;
    public static final int GLOBAL_ZK_LAYER = 1;
    public static final int GLOBAL_SCRAPED_LAYER = 2;
    public static final int GLOBAL_METADATA_LAYER = 3;
    public static final int NUM_LOCAL_LAYERS = 1;
    public static final int NUM_GLOBAL_LAYERS = 4;
    private FlipperRestInterface flipperRest;
    private LiveProperties liveProperties;
    private DecodedKeyFactory decodedKeyFactory;
    private static final String[] STARTUP_GLOBAL_PROPERTIES = new String[]{"metadata", "CM", "AAA", "supportedProductLocales", "supportedContentLocales", "supportedCurrencies", "supportedFonts", "productLocaleMap", "contentLocaleMap", "fontsMap", "timeZones", "cookieDomain", "cookiePath", "cookieSecure", "aliasRoots", "archiveLocationFileSchemeRoot", "deploymentPath"};
    private static final String DEFAULT_VALUE = "myDefault";

    FlipperConfigurationImpl(DecodedKeyFactory decodedKeyFactory, FlipperRestInterface flipperRest) {
        this.decodedKeyFactory = decodedKeyFactory;
        this.flipperRest = flipperRest;
        this.initialize();
    }

    public FlipperConfigurationImpl() {
    }

    private void initialize() {
        this.liveProperties = new LiveProperties(this.flipperRest);
        try (AutoCloseable closer = RequestContext.open((String)("FlipperConfigurationImpl:" + this.decodedKeyFactory.getLocalPath()));){
            this.innerInitialize();
        }
        catch (Exception e) {
            LOG.error("unexpected exception", (Throwable)e);
        }
    }

    private void innerInitialize() {
        if (ConfigurationUtils.isCMEnabled()) {
            ArchaiusSetup archaiusSetup = ConfigurationPropertyFactory.getInstance().getArchaiusSetup();
            String AAAsettings = "aaa_default";
            CogStartupTransfer configTrans = new CogStartupTransfer(archaiusSetup);
            try {
                PropertiesConfiguration settings = configTrans.scrapeGlobalSettings();
                if (settings != null) {
                    AAAsettings = settings.getString("AAA");
                    settings.clearProperty("AAA");
                    settings.clearProperty("AAA_NOSENSDATA");
                    this.liveProperties.replace((Configuration)settings, "global", 2);
                }
            }
            catch (Exception e) {
                LOG.error("failed to update global settings layer 2", (Throwable)e);
            }
            if (ConfigurationUtils.isDynamicNamespaceEnabled()) {
                try {
                    LOG.debug("Load the configuration0.properties file if exists.");
                    PropertiesConfiguration currentsettings = this.loadGlobalConfigProperties(archaiusSetup.getPropertiesReader(), 0);
                    String newsettings = StartupXML.getInstance().buildAAAsettings(AAAsettings);
                    currentsettings.setProperty("AAA.global", (Object)newsettings);
                    LOG.debug("Set AAA.global settings from cogstartup.xml to configuration0.properties");
                    this.liveProperties.replace((Configuration)currentsettings, "global", 0);
                }
                catch (Exception e1) {
                    LOG.error("failed to update global settings layer 0", (Throwable)e1);
                }
            }
            try {
                LOG.debug("Load the migrated ZK properties file {} if exists.");
                PropertiesConfiguration zkSettings = this.loadMigratedZKProperties(archaiusSetup.getPropertiesReader());
                zkSettings = ConfigurationMigrationHelper.getInstance().maybeMigrateConfiguration(zkSettings);
                if (zkSettings != null) {
                    LOG.info("copied settings from zookeeper: {}", (Object)FlipperConfigurationImpl.propertiesToString(zkSettings));
                    this.liveProperties.replace((Configuration)zkSettings, "global", 1);
                }
            }
            catch (Exception e) {
                LOG.error("failed to update global settings layer 1", (Throwable)e);
            }
            try {
                PropertiesConfiguration metadata = archaiusSetup.getMetadataProperties();
                LOG.info("using global metadata settings: {}", (Object)FlipperConfigurationImpl.propertiesToString(metadata));
                this.liveProperties.replace((Configuration)metadata, "global", 3);
            }
            catch (Exception e) {
                LOG.error("failed to update metadata settings layer 3", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PropertiesConfiguration loadGlobalConfigProperties(PropertiesReader propertiesReader, int layer) {
        PropertiesConfiguration config = PropertiesConfigurationFactory.make();
        File configPropFile = propertiesReader.getFileForPath("global", layer);
        if (!configPropFile.exists()) {
            LOG.debug("properties file {} does not exist.", (Object)configPropFile);
            return config;
        }
        LOG.debug("try to load properties from {}", (Object)configPropFile);
        try (CheckedInputStreamFilter checked = new CheckedInputStreamFilter((InputStream)new FileInputStream(configPropFile));){
            config.load((InputStream)checked);
            PropertiesConfiguration propertiesConfiguration = config;
            return propertiesConfiguration;
        }
        catch (Exception e) {
            LOG.warn("exception loading existing properties from {}", (Object)configPropFile, (Object)e);
            return PropertiesConfigurationFactory.make();
        }
    }

    private PropertiesConfiguration loadMigratedZKProperties(PropertiesReader propertiesReader) {
        return this.loadGlobalConfigProperties(propertiesReader, 1);
    }

    private static String propertiesToString(PropertiesConfiguration props) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            PropertiesConfigurationLayout layout = props.getLayout();
            layout.setLineSeparator(" , ");
            props.setLayout(layout);
            props.save((OutputStream)baos);
            return baos.toString();
        }
        catch (ConfigurationException e) {
            LOG.error("unexpected exception rendering properties as string", (Throwable)e);
            return "-none-";
        }
    }

    private int getNumLayers(String path) {
        return path.startsWith("global") ? 4 : 1;
    }

    @Override
    public JSONObject getall(String pathPrefix) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (pathPrefix.isEmpty()) {
            JSONObject globalJson = this.getKeysForPath("global", true);
            jsonObject.put((Object)"global", (Object)globalJson);
        } else {
            JSONObject pathJson = this.getKeysForPath(pathPrefix, pathPrefix.equals("global"));
            jsonObject.put((Object)pathPrefix, (Object)pathJson);
        }
        return jsonObject;
    }

    private JSONObject getKeysForPath(String pathPrefix, boolean bSkipStartup) {
        JSONObject jsonObject = new JSONObject();
        try (ConfigHolder holder = this.liveProperties.getMergedView(pathPrefix, this.getNumLayers(pathPrefix));){
            Iterator list = holder.getConfig().getKeys();
            if (list != null) {
                while (list.hasNext()) {
                    String key = (String)list.next();
                    if (bSkipStartup && this.isStartupGlobalSettings(key)) continue;
                    jsonObject.put((Object)key, (Object)holder.getConfig().getString(key));
                }
            }
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
    }

    private boolean isStartupGlobalSettings(String key) {
        for (String prop : STARTUP_GLOBAL_PROPERTIES) {
            if (!key.startsWith(prop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject get(String dir, boolean bSync) throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (dir == null) {
            return jsonObject;
        }
        if ("nodes/*".equals(dir)) {
            jsonObject = this.getAllNodeValues();
        } else if (dir.length() > 2 && dir.endsWith("/*")) {
            String path = dir.substring(0, dir.length() - 2);
            path = ConfigurationUtils.replacePathDelimiter((String)path);
            jsonObject = this.getall(path);
        } else if ("nodes".equals(dir)) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll((Collection)Lists.newArrayList((Iterable)this.flipperRest.listPaths()));
            jsonObject.put((Object)"nodes", (Object)jsonArray);
        } else if (dir.startsWith("nodes/") || dir.startsWith("global/")) {
            String key = dir;
            if (dir.startsWith("nodes/")) {
                key = dir.substring("nodes/".length());
            }
            DecodedKey dk = this.decodedKeyFactory.decodeKey(key);
            String path = dk.getPath();
            try (ConfigHolder holder = this.liveProperties.getMergedView(path, this.getNumLayers(path));){
                String value = holder.getConfig().getString(dk.getPropertyKey());
                jsonObject.put((Object)dk.getPropertyKey(), (Object)value);
            }
        } else {
            String propValue = bSync ? this.getValue(dir) : this.getCachedValue(dir);
            jsonObject.put((Object)dir, (Object)propValue);
        }
        return jsonObject;
    }

    private void getAllValues(JSONObject jsonObject, PropertiesConfiguration config) {
        if (jsonObject == null) {
            return;
        }
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = ((String)iter.next()).toString();
            Object value = config.getProperty(key);
            jsonObject.put((Object)key, value);
        }
    }

    @Override
    public void putMany(String scope, List<Map.Entry<String, String>> settings) throws Exception {
        if (settings.isEmpty()) {
            return;
        }
        int layer = 0;
        PropertiesConfiguration props = this.liveProperties.getView(scope, layer);
        if (props == null) {
            props = PropertiesConfigurationFactory.make();
        }
        for (Map.Entry<String, String> pair : settings) {
            props.setProperty(pair.getKey(), (Object)pair.getValue());
        }
        this.liveProperties.update((Configuration)props, scope, layer);
    }

    @Override
    public void deleteKey(String dir) throws Exception {
        DecodedKey dk = this.decodedKeyFactory.decodeKey(dir);
        this.liveProperties.deletekey(dk.getPath(), dk.getPropertyKey(), 0);
    }

    @Override
    public String getCachedValue(String rawPath) {
        String keypath = this.getKeyPath(rawPath);
        LOG.debug("getCachedValue - rawpath= '{}', keypath = '{}'", (Object)rawPath, (Object)keypath);
        return ConfigurationPropertyFactory.getInstance().getStringProperty(keypath, DEFAULT_VALUE).get();
    }

    @Override
    public String getValue(String rawPath) {
        String keypath = this.getKeyPath(rawPath);
        LOG.debug("getValue - rawpath= '{}', keypath = '{}'", (Object)rawPath, (Object)keypath);
        String value = this.getLiveValue(keypath);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return ConfigurationPropertyFactory.getInstance().getStringProperty(keypath, DEFAULT_VALUE).get();
    }

    protected String getKeyPath(String rawPath) {
        ConfigurationPropertyFactory configPropInst = ConfigurationPropertyFactory.getInstance();
        String keyPath = rawPath;
        if (keyPath != null && keyPath.startsWith("expandconfig/")) {
            keyPath = keyPath.substring(13, keyPath.length());
            keyPath = ConfigurationUtils.replacePathDelimiter((String)keyPath);
        } else {
            keyPath = ConfigurationUtils.replacePathDelimiter((String)keyPath);
            keyPath = configPropInst.getNoneSensitiveKeyname(keyPath);
        }
        return keyPath;
    }

    private String getLiveValue(String keyPath) {
        try (ConfigHolder holder = this.liveProperties.getMergedView("global", 4);){
            String value = holder.getConfig().getString(keyPath);
            if (StringUtils.isNotEmpty((String)value)) {
                LOG.debug("reply with live global value, key: {}, value: \"{}\"", (Object)keyPath, (Object)value);
                String string = value;
                return string;
            }
        }
        return null;
    }

    @Override
    public JSONObject getMany(ArrayList<String> keys) {
        if (keys == null || keys.isEmpty()) {
            LOG.debug("getMany() - keys list is empty. Return null.");
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try (ConfigHolder holder = this.liveProperties.getMergedView("global", 4);){
            for (int ii = 0; ii < keys.size(); ++ii) {
                String key = keys.get(ii);
                String value = holder.getConfig().getString(key);
                LOG.debug("getMany() - add live global value, key: {}, value: \"{}\"", (Object)key, (Object)value);
                jsonObject.put((Object)key, (Object)value);
            }
        }
        return jsonObject;
    }

    public JSONObject getAllNodeValues() throws Exception {
        JSONObject jsonObject = new JSONObject();
        for (String node : this.flipperRest.listPaths()) {
            if (node.equals("global")) continue;
            JSONObject nodeValues = this.getNodeValues(node);
            jsonObject.put((Object)node, (Object)nodeValues);
        }
        return jsonObject;
    }

    public JSONObject getNodeValues(String nodeName) throws Exception {
        JSONObject jsonObject = new JSONObject();
        try (ConfigHolder holder = this.liveProperties.getMergedView(nodeName, this.getNumLayers(nodeName));){
            Iterator iterator = holder.getConfig().getKeys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                jsonObject.put((Object)key, (Object)holder.getConfig().getString(key));
            }
        }
        return jsonObject;
    }

    @Override
    public void putTenantInfo(String scope, ArrayList<Map.Entry<String, String>> settings, String subject) throws Exception {
        if (settings.isEmpty()) {
            return;
        }
        String tenantFullPath = this.getTenantFullPath(scope, subject);
        PropertiesConfiguration props = this.flipperRest.getConfiguration(tenantFullPath);
        if (props == null) {
            props = PropertiesConfigurationFactory.make();
        }
        for (Map.Entry<String, String> pair : settings) {
            props.setProperty(pair.getKey(), (Object)pair.getValue());
        }
        this.liveProperties.updateStore((Configuration)props, this.getTenantFullPath(scope, subject));
    }

    protected String getTenantFullPath(String scope, String subject) {
        return scope + "/" + subject + ".properties";
    }

    @Override
    public JSONObject getTenantResource(String tenantScope, String subject) {
        JSONObject jsonObject = new JSONObject();
        if (tenantScope == null) {
            return jsonObject;
        }
        String tenantFullPath = this.getTenantFullPath(tenantScope, subject);
        PropertiesConfiguration config = this.flipperRest.getConfiguration(tenantFullPath);
        if (config != null) {
            this.getAllValues(jsonObject, config);
        }
        return jsonObject;
    }

    @Override
    public JSONObject getPersistedKeys(String scope) {
        String path;
        PropertiesConfiguration config;
        JSONObject jsonObject = new JSONObject();
        if (scope != null && scope.equals("global") && (config = this.flipperRest.getConfiguration(path = "global/configuration0.properties")) != null) {
            this.getAllValues(jsonObject, config);
        }
        return jsonObject;
    }

    @Override
    public int deleteTenantResource(String tenantScope) throws Exception {
        return this.flipperRest.delete(tenantScope);
    }

    protected void setLivePropertiesForTest(LiveProperties liveProp) {
        this.liveProperties = liveProp;
    }
}

