/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.acl;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.setup.ArchaiusSetup;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.json.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(AccessDefinition.class);
    public static final String DEF_FILENAME = "configuration/configACLDef.json";
    public static final String PERM_SYSADMIN = "SA";
    public static final String PERM_NOREAD = "NOREAD";
    public static final String PERM_UC_LEADING = "can";
    public static final String PERM_NOWRITE = "NOWRITE";
    private static Set<String> keySetRead = new HashSet<String>();
    private static Set<String> keySetWrite = new HashSet<String>();
    private static HashMap<String, String> aclReadAccess = new HashMap();
    private static HashMap<String, String> aclWriteAccess = new HashMap();
    private boolean accessCheckEnabled = true;
    private ArrayList<String> predefinedSecureKeys;

    public AccessDefinition() {
        this.getPredefinedSecureKeys();
    }

    public AccessDefinition(String absolutePath) {
        this.getPredefinedSecureKeys();
        this.loadDefinition(absolutePath);
    }

    public void loadDefinition(String absolutePath) {
        JsonParser jsonParser = new JsonParser();
        try {
            FileReader reader = new FileReader(absolutePath);
            LOG.info("loading config acl file, {}", (Object)absolutePath);
            Object obj = jsonParser.parse((Reader)reader);
            JsonObject keys = (JsonObject)obj;
            keySetRead = this.loadACLData((JsonObject)keys.get("read"), aclReadAccess);
            keySetWrite = this.loadACLData((JsonObject)keys.get("write"), aclWriteAccess);
        }
        catch (FileNotFoundException fe) {
            LOG.debug("file: {} doesn't exist.", (Object)absolutePath);
            this.accessCheckEnabled = false;
        }
        catch (Exception e) {
            LOG.error("Exception when loading file, {} . Exception message: {}", (Object)absolutePath, (Object)e.getMessage());
        }
    }

    protected Set<String> loadACLData(JsonObject aclJson, HashMap<String, String> aclmap) throws Exception {
        Set keyset = aclJson.keySet();
        for (String key : keyset) {
            aclmap.put(key, aclJson.get(key).toString());
        }
        return keyset;
    }

    public boolean isAccessCheckEnabled() {
        return this.accessCheckEnabled;
    }

    public void setAccessCheckStatus(boolean bEnabled) {
        this.accessCheckEnabled = bEnabled;
    }

    public Set<String> getReadAccessKeys() {
        return keySetRead;
    }

    public boolean shouldCheckReadAccess(String keyName) {
        return keySetRead.contains(keyName);
    }

    public boolean shouldCheckWriteAccess(String keyName) {
        return keySetWrite.contains(keyName);
    }

    public String getReadAccess(String key) {
        return aclReadAccess.get(key);
    }

    public String getWriteAccess(String key) {
        return aclWriteAccess.get(key);
    }

    public HashMap<String, String> getKeysReadAccessJson() {
        return aclReadAccess;
    }

    public boolean noRead(String key) {
        boolean noRead = false;
        String acl = this.getReadAccess(key);
        if (!StringUtils.isBlank((String)acl)) {
            noRead = acl.equals(PERM_NOREAD);
        }
        return noRead;
    }

    public boolean requireSA(String key, String acl) {
        boolean requireSA = false;
        if (!StringUtils.isBlank((String)acl)) {
            requireSA = acl.equals(PERM_SYSADMIN);
        }
        return requireSA;
    }

    public boolean requireUCapCheck(String key, String acl) {
        boolean requireUC = false;
        if (!StringUtils.isBlank((String)acl)) {
            requireUC = acl.startsWith(PERM_UC_LEADING);
        }
        return requireUC;
    }

    public boolean noWrite(String key, String acl) {
        boolean noWrite = false;
        if (!StringUtils.isBlank((String)acl)) {
            noWrite = acl.equals(PERM_NOWRITE);
        }
        return noWrite;
    }

    private void getPredefinedSecureKeys() {
        ArchaiusSetup archaiusSetup = ConfigurationPropertyFactory.getInstance().getArchaiusSetup();
        this.predefinedSecureKeys = archaiusSetup.getPredefinedSecureKeys();
        LOG.debug("predefinedSecureKeys: {}", this.predefinedSecureKeys);
    }

    public boolean isPredefinedSecuredKey(String keyName) {
        return this.predefinedSecureKeys.contains(keyName);
    }

    public boolean blockRead(String key, boolean isSA, HashSet<String> capabilities) {
        boolean bBlock = false;
        String acl = this.getReadAccess(key);
        if (this.noRead(key)) {
            bBlock = true;
            LOG.debug("blockRead - config parameter, {} is not allowed to read.", (Object)key);
        } else if (this.requireSA(key, acl)) {
            LOG.debug("blockRead - config parameter, {} requires system admin privilege to read", (Object)key);
            bBlock = !isSA;
        } else if (this.requireUCapCheck(key, acl)) {
            LOG.debug("blockRead - config parameter, {} requires user capability '{}' to read", (Object)key, (Object)acl);
            bBlock = !this.checkUserCap(acl, capabilities);
        }
        LOG.debug("blockRead - config parameter, {} is '{}' to read", (Object)key, (Object)(bBlock ? "BLOCKED" : "ALLOWED"));
        return bBlock;
    }

    public boolean blockWrite(String key, boolean isSA, HashSet<String> capabilities) {
        boolean bBlock = false;
        String acl = this.getWriteAccess(key);
        if (this.noWrite(key, acl)) {
            bBlock = true;
            LOG.debug("blockWrite - config parameter, {} is not allowed to write.", (Object)key);
        } else if (this.requireSA(key, acl)) {
            LOG.debug("blockWrite - config parameter, {} requires system admin privilege to write", (Object)key);
            bBlock = !isSA;
        } else if (this.requireUCapCheck(key, acl)) {
            LOG.debug("blockWrite - config parameter, {} requires user capability '{}' to write", (Object)key, (Object)acl);
            bBlock = !this.checkUserCap(acl, capabilities);
        }
        LOG.debug("blockWrite - config parameter, {} is '{}' to write", (Object)key, (Object)(bBlock ? "BLOCKED" : "ALLOWED"));
        return bBlock;
    }

    public boolean checkUserCap(String userCap, HashSet<String> capabilities) {
        return capabilities != null && capabilities.contains(userCap);
    }

    public boolean blockUpdate(String key) {
        boolean toBlock = false;
        String acl = this.getWriteAccess(key);
        if (acl != null) {
            toBlock = acl.equals(PERM_NOWRITE);
        }
        return toBlock;
    }
}

