/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.metadata;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.IConfiguration;
import com.ibm.bi.config.metadata.ConfigCategory;
import com.ibm.bi.config.setup.CogXMLConfiguration;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.netflix.config.DynamicStringProperty;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CategoryDefinition
extends CogXMLConfiguration {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CategoryDefinition.class);
    private static LinkedHashMap<String, ConfigCategory> categories = new LinkedHashMap();
    private static ArrayList<String> uiParameters = new ArrayList();
    private static HashMap<String, JsonArray> localizedUIDocs = new HashMap();
    public static final String CAT_ATTR_NAME = "name";
    public static final String CAT_ATTR_ID = "id";
    public static final String CAT_ATTR_LABEL = "label";
    public static final String CAT_ATTR_CHILDREN = "children";
    public static final String CAT_ATTR_TYPE = "type";
    public static final String CAT_ATTR_DEFAULT = "default";
    public static final String CAT_ATTR_DESCRIPTION = "description";
    public static final String CAT_ATTR_VALUE = "value";
    public static final String CAT_ATTR_MAXVALUE = "maxValue";
    public static final String CAT_ATTR_MINVALUE = "minValue";
    public static final String CAT_ATTR_ENCRYPTED = "encrypted";
    public static final String CAT_NODE_PARAMETERS = "parameters";
    public static final String CAT_NODE_PARAMETER = "parameter";
    private static final String[] DATATYPE_STRING = new String[]{"string", "password"};
    private static final String[] DATATYPE_INT = new String[]{"int"};
    private static final String[] DATATYPE_LONG = new String[]{"long"};
    private static final String[] DATATYPE_BOOLEAN = new String[]{"boolean"};
    private static final String[] DATATYPE_DOUBLE = new String[]{"double"};
    private static final String METADATA_ATTR_MINVALUE = "minValue";
    private static final String METADATA_ATTR_MAXVALUE = "maxValue";

    public CategoryDefinition(String string) throws ConfigurationException {
        super(string);
    }

    public CategoryDefinition(URL url) throws ConfigurationException {
        super(url);
    }

    private void addCategory(ConfigCategory configCategory) {
        categories.put(configCategory.getCategoryID(), configCategory);
        uiParameters.addAll(configCategory.getParamList());
    }

    public LinkedHashMap<String, ConfigCategory> getCategories() {
        return categories;
    }

    public ArrayList<String> getUIParameters() {
        return uiParameters;
    }

    public JsonArray getLocalizedUIDocs(String localeID) {
        return localizedUIDocs.get(localeID);
    }

    protected void constructHierarchy(Document document) {
        Element documentElement = document.getDocumentElement();
        NodeList categoryList = documentElement.getChildNodes();
        for (int i = 0; i < categoryList.getLength(); ++i) {
            Node categoryNode = categoryList.item(i);
            if (!(categoryNode instanceof Element)) continue;
            Element categoryElem = (Element)categoryNode;
            ConfigCategory cat = new ConfigCategory(categoryElem.getAttribute(CAT_ATTR_NAME), categoryElem.getAttribute(CAT_ATTR_LABEL));
            cat.setConfigParmList(categoryElem);
            this.addCategory(cat);
        }
    }

    public JsonArray getUIDoc(String localeID, IConfiguration configInst) {
        if (categories.isEmpty()) {
            return null;
        }
        return this.getUIDoc(localeID, configInst, null);
    }

    public JsonArray getUIDoc(String localeID, IConfiguration configInst, String mode) {
        LOG.debug("getUIDoc() - start. localeID = {}, mode = {}", (Object)localeID, (Object)mode);
        JsonArray configSpec = this.getLocalizedUIDocs(localeID);
        if (configSpec == null) {
            LOG.debug("getUIDoc() - create uidoc. localeID = {}, mode = {}", (Object)localeID, (Object)mode);
            configSpec = this.createUIDoc(localeID);
            localizedUIDocs.put(localeID, configSpec);
        } else {
            LOG.debug("getUIDoc() - get cached uidoc. localeID = {}, mode = {}", (Object)localeID, (Object)mode);
        }
        this.fillParamValues(configSpec, configInst, mode);
        LOG.debug("getUIDoc() - end. localeID = {}, mode = {}", (Object)localeID, (Object)mode);
        return configSpec;
    }

    protected JsonArray createUIDoc(String localeID) {
        JsonArray configSpec = new JsonArray();
        for (Map.Entry<String, ConfigCategory> entry : categories.entrySet()) {
            JsonObject catJson = new JsonObject();
            ConfigCategory configCat = entry.getValue();
            this.collectConfigParms(catJson, configCat, localeID);
            configSpec.add((Object)catJson);
        }
        return configSpec;
    }

    protected void fillParamValues(JsonArray configSpec, IConfiguration configInst, String mode) {
        JsonObject curValues = new JsonObject();
        if (StringUtils.isEmpty((String)mode) || mode.equals("live")) {
            LOG.debug("fillParamValues() - Retrieve live values. mode = {}", (Object)mode);
            curValues.putAll((Map)configInst.getMany(uiParameters));
        } else if (mode.equals("readonly")) {
            LOG.debug("fillParamValues() - Retrieve cached values. mode = {}", (Object)mode);
            this.getCachedValues(curValues);
        }
        for (Object obj : configSpec) {
            JsonObject catObj = (JsonObject)obj;
            JsonArray params = (JsonArray)catObj.get(CAT_ATTR_CHILDREN);
            if (params == null) continue;
            for (Object param : params) {
                JsonObject paramObj = (JsonObject)param;
                String paramId = paramObj.getString(CAT_ATTR_ID);
                String paramValue = (String)curValues.get(paramId);
                if (paramValue == null) continue;
                paramObj.put(CAT_ATTR_VALUE, (Object)paramValue);
            }
        }
        LOG.debug("fillParamValues() - finish.");
    }

    protected void getCachedValues(JsonObject curValues) {
        ConfigurationPropertyFactory configPropInst = ConfigurationPropertyFactory.getInstance();
        for (int ii = 0; ii < uiParameters.size(); ++ii) {
            String key = uiParameters.get(ii);
            String value = configPropInst.getStringProperty(key).get();
            if (StringUtils.isNotEmpty((String)value)) {
                LOG.debug("getCachedValues() - get global value, key: {}, value: \"{}\"", (Object)key, (Object)value);
                curValues.put(key, (Object)value);
                continue;
            }
            LOG.debug("getCachedValues() - Unable to get global value, key: {}", (Object)key);
        }
    }

    protected void collectConfigParms(JsonObject catJson, ConfigCategory configCat, String localeID) {
        catJson.put(CAT_ATTR_ID, (Object)configCat.getCategoryID());
        catJson.put(CAT_ATTR_LABEL, configCat.getCategoryName(localeID));
        catJson.put(CAT_ATTR_CHILDREN, (Object)configCat.getParameters(localeID));
    }

    public void isInputDataValid(JsonObject objectIn, ArrayList<String> errMsgs) {
        ConfigurationPropertyFactory configPropInst = ConfigurationPropertyFactory.getInstance();
        try {
            Set keySet = objectIn.keySet();
            for (String key : keySet) {
                String mdKey = "metadata." + key;
                DynamicStringProperty strProp = configPropInst.getStringProperty(mdKey);
                if (strProp == null) {
                    LOG.debug("isInputDataValid() - metadataInfo is not defined for key '{}'. Skip the validataion.", (Object)key);
                    continue;
                }
                Object keyvalue = objectIn.get(key);
                String msg = "";
                if (!this.isValueValid(strProp.get(), keyvalue, key, errMsgs)) {
                    msg = "NOT";
                }
                LOG.debug("The value '{}' for key '{}' is {} valid.", new Object[]{keyvalue, key, msg});
            }
        }
        catch (Exception e) {
            errMsgs.add("Exception when validate input data: " + e.getMessage());
        }
    }

    protected boolean isValueValid(String metadataInfo, Object keyvalue, String key, ArrayList<String> errMsgs) {
        try {
            JsonObject metadata = JsonObject.parseString((String)metadataInfo, (boolean)false);
            String datatype = (String)metadata.get(CAT_ATTR_TYPE);
            if (StringUtils.isBlank((String)datatype)) {
                LOG.debug("isValueValid() - datatype is not defined for key '{}'. Skip the validataion.", (Object)key);
                return true;
            }
            return this.validateDataTypes(datatype, keyvalue, key, metadata, errMsgs);
        }
        catch (Exception e) {
            LOG.debug("isValueValid() - metadataInfo '{}' is not defined for key '{}'. Skip the validataion.", (Object)metadataInfo, (Object)key);
            return true;
        }
    }

    protected boolean validateDataTypes(String datatype, Object keyvalueObj, String key, JsonObject metadata, ArrayList<String> errMsgs) {
        if (!(keyvalueObj instanceof String)) {
            return true;
        }
        String keyvalue = (String)keyvalueObj;
        if (ArrayUtils.contains((Object[])DATATYPE_STRING, (Object)datatype.toLowerCase())) {
            return true;
        }
        String msgPref = "The value '" + keyvalue + "' for key '" + key + "'";
        if (ArrayUtils.contains((Object[])DATATYPE_BOOLEAN, (Object)datatype.toLowerCase())) {
            if (StringUtils.equalsIgnoreCase((String)keyvalue, (String)"true") || StringUtils.equalsIgnoreCase((String)keyvalue, (String)"false")) {
                return true;
            }
            errMsgs.add(msgPref + " is not a valid type.");
            return false;
        }
        try {
            if (ArrayUtils.contains((Object[])DATATYPE_INT, (Object)datatype.toLowerCase())) {
                int ivalue = Integer.parseInt(keyvalue);
                return this.validateRangeWithErrorMsg(metadata, ivalue, errMsgs, msgPref);
            }
            if (ArrayUtils.contains((Object[])DATATYPE_LONG, (Object)datatype.toLowerCase())) {
                long ivalue = Long.parseLong(keyvalue);
                return this.validateRangeWithErrorMsg(metadata, ivalue, errMsgs, msgPref);
            }
            if (ArrayUtils.contains((Object[])DATATYPE_DOUBLE, (Object)datatype.toLowerCase())) {
                double ivalue = Double.parseDouble(keyvalue);
                return this.validateRangeWithErrorMsg(metadata, new Double(ivalue), errMsgs, msgPref);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.debug("Invalid data type: {}", (Object)keyvalue);
            return this.failWithErrorMsg(msgPref + " is not a valid type.", errMsgs);
        }
        catch (Exception e) {
            LOG.debug("Exception when validateDataTypes: ", (Throwable)e);
            return this.failWithErrorMsg(msgPref + " is not a valid type.", errMsgs);
        }
        LOG.debug("validateDataTypes() - datatype '{}' is not supported, return false.", (Object)datatype);
        return this.failWithErrorMsg("The datatype '" + datatype + "' for key '" + key + "' is not supported.", errMsgs);
    }

    protected boolean failWithErrorMsg(String msg, ArrayList<String> errMsgs) {
        errMsgs.add(msg);
        return false;
    }

    protected boolean validateRangeWithErrorMsg(JsonObject metadata, Object numberObj, ArrayList<String> errMsgs, String msgPref) {
        if (!this.checkNumberRange(metadata, numberObj)) {
            return this.failWithErrorMsg(msgPref + " is not in valid range.", errMsgs);
        }
        return true;
    }

    protected boolean checkNumberRange(JsonObject metadata, Object numberObj) {
        String minvalue = metadata.getString("minValue");
        String maxvalue = metadata.getString("maxValue");
        if (StringUtils.isBlank((String)minvalue) && StringUtils.isBlank((String)maxvalue)) {
            return true;
        }
        try {
            long ivalue;
            int ivalue2;
            if (!StringUtils.isBlank((String)minvalue)) {
                if (numberObj instanceof Integer) {
                    int minval = Integer.parseInt(minvalue);
                    ivalue2 = (Integer)numberObj;
                    if (ivalue2 < minval) {
                        return false;
                    }
                } else if (numberObj instanceof Long) {
                    long minval = Long.parseLong(minvalue);
                    ivalue = (Long)numberObj;
                    if (ivalue < minval) {
                        return false;
                    }
                } else if (numberObj instanceof Double) {
                    double minval = Double.parseDouble(minvalue);
                    double ivalue3 = (Double)numberObj;
                    if (ivalue3 < minval) {
                        return false;
                    }
                }
            }
            if (!StringUtils.isBlank((String)maxvalue)) {
                if (numberObj instanceof Integer) {
                    int maxval = Integer.parseInt(maxvalue);
                    ivalue2 = (Integer)numberObj;
                    if (ivalue2 > maxval) {
                        return false;
                    }
                } else if (numberObj instanceof Long) {
                    long maxval = Long.parseLong(maxvalue);
                    ivalue = (Long)numberObj;
                    if (ivalue > maxval) {
                        return false;
                    }
                } else if (numberObj instanceof Double) {
                    double maxval = Double.parseDouble(maxvalue);
                    double ivalue4 = (Double)numberObj;
                    if (ivalue4 > maxval) {
                        return false;
                    }
                }
            }
        }
        catch (NumberFormatException ee) {
            LOG.error("Invalid metadata definition for min/max value: metadata='{}'.return false.", (Object)metadata.toString());
            return false;
        }
        LOG.debug("checkNumberRange() - metadata='{}', number='{}', return true.", (Object)metadata, numberObj);
        return true;
    }
}

