/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.metadata;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.metadata.ParameterProperty;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigCategory {
    private String id;
    private String nameRef;
    private LinkedHashMap<String, ParameterProperty> parmMap = new LinkedHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(ConfigCategory.class);

    public ConfigCategory(String id, String nameRef) {
        this.id = id;
        this.nameRef = nameRef;
    }

    public String getCategoryID() {
        return this.id;
    }

    public JsonArray getParameters(String localeID) {
        JsonArray parameters = new JsonArray();
        ConfigurationPropertyFactory configPropInst = ConfigurationPropertyFactory.getInstance();
        for (Map.Entry<String, ParameterProperty> entry : this.parmMap.entrySet()) {
            JsonObject parmJson = new JsonObject();
            ParameterProperty parmObj = entry.getValue();
            String id = parmObj.getConfigParmName();
            parmJson.put("id", (Object)id);
            parmJson.put("label", (Object)this.getLocalizedValue(parmObj.getLabelID(), localeID));
            parmJson.put("type", (Object)parmObj.getType());
            parmJson.put("default", (Object)parmObj.getDefaultValue());
            parmJson.put("description", (Object)this.getLocalizedValue(parmObj.getDescriptionID(), localeID));
            parmJson.put("value", (Object)configPropInst.getStringProperty(id).get());
            if (parmObj.getMaxValue() != null) {
                parmJson.put("maxValue", (Object)parmObj.getMaxValue());
            }
            if (parmObj.getMinValue() != null) {
                parmJson.put("minValue", (Object)parmObj.getMinValue());
            }
            parameters.add((Object)parmJson);
        }
        return parameters;
    }

    public Set<String> getParamList() {
        return this.parmMap.keySet();
    }

    protected String getLocalizedValue(String msgID, String localeID) {
        return ConfigurationUtils.getLocalizedValue((String)msgID, (String)localeID);
    }

    public Object getCategoryName(String localeID) {
        return ConfigurationUtils.getLocalizedValue((String)this.nameRef, (String)localeID);
    }

    public void setConfigParmList(Element categoryElem) {
        if (categoryElem == null) {
            return;
        }
        NodeList serviceNodeList = categoryElem.getChildNodes();
        for (int i = 0; i <= serviceNodeList.getLength(); ++i) {
            Node serviceNode = serviceNodeList.item(i);
            if (!(serviceNode instanceof Element)) continue;
            String serviceName = serviceNode.getNodeName();
            NodeList parametersList = ((Element)serviceNode).getElementsByTagName("parameters");
            if (parametersList == null || parametersList.getLength() <= 0) {
                LOG.warn("Did not find \"parameters\" element under the service: " + serviceName);
                continue;
            }
            Element parameters = (Element)parametersList.item(0);
            NodeList parmList = parameters.getElementsByTagName("parameter");
            for (int j = 0; j < parmList.getLength(); ++j) {
                Element param = (Element)parmList.item(j);
                String parmName = serviceName + "." + param.getAttribute("name");
                ParameterProperty parmObj = new ParameterProperty(parmName);
                parmObj.setProperties(param);
                this.parmMap.put(parmName, parmObj);
            }
        }
    }
}

