/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.migration;

import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.InputArchive;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.persistence.FileSnap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationMigrationHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationMigrationHelper.class);
    public static final String ZOOKEEPER_UPGRADED = "zookeeper.upgraded";
    public static final String ZOOKEEPER_UPGRADE_CLEAN = "zookeeper.upgraded.clean";
    public static final int ZOOKEEPER_UPGRADE_CLEAN_VER = 2;
    private static final String ZOOKEEPER_DATAPATH = "configuration/data/version-2";
    private static final String ZOOKEEPER_SNAPSHOT_PREFIX = "snapshot.";
    private static final String GLOBAL_CONFIG_PATH = "/configuration/global/";
    private static final String[] IGNORED_PROPERTIES = new String[]{"Admin.ApacheDS.started", "Configuration.LegacyLaunchable", "supportedProductLocales", "supportedContentLocales", "supportedCurrencies", "supportedFonts", "productLocaleMap", "contentLocaleMap", "fontsMap", "timeZones", "cookieDomain", "cookiePath", "cookieSecure", "aliasRoots", "archiveLocationFileSchemeRoot"};
    private Set<String> ignoredPropertyKeySet;
    private static ConfigurationMigrationHelper instance;
    private String zkDataFilePath = ConfigurationUtils.resolvePath((String)"configuration/data/version-2");

    public static ConfigurationMigrationHelper getInstance() {
        if (instance == null) {
            instance = new ConfigurationMigrationHelper();
        }
        return instance;
    }

    public ConfigurationMigrationHelper() {
        this.ignoredPropertyKeySet = new HashSet<String>();
        Collections.addAll(this.ignoredPropertyKeySet, IGNORED_PROPERTIES);
    }

    public String getZkDataFilePath() {
        return this.zkDataFilePath;
    }

    public void setZkDataFilePath(String path) {
        this.zkDataFilePath = path;
    }

    public PropertiesConfiguration maybeMigrateConfiguration(PropertiesConfiguration propertiesFromGlobalFile) {
        try {
            boolean zkupgraded = false;
            if (propertiesFromGlobalFile != null) {
                zkupgraded = propertiesFromGlobalFile.getBoolean(ZOOKEEPER_UPGRADED, false);
            }
            if (!zkupgraded) {
                PropertiesConfiguration zkprops = this.checkAndLoadZookeeperSnapshot();
                if (zkprops != null) {
                    zkprops.setProperty(ZOOKEEPER_UPGRADED, (Object)true);
                    zkprops.setProperty(ZOOKEEPER_UPGRADE_CLEAN, (Object)2);
                }
                return zkprops;
            }
            log.debug("Zookeeper migration has been done. No need to migrate again.");
            log.debug("remove properties that should have been excluded by earlier Zookeeper migration.");
            return this.cleanUpMigratedProperties(propertiesFromGlobalFile);
        }
        catch (Exception e) {
            log.warn("Error occurred while migrating configuration from zookeeper snapshot files. - ", (Throwable)e);
            return null;
        }
    }

    PropertiesConfiguration cleanUpMigratedProperties(PropertiesConfiguration propertiesFromGlobalFile) {
        if (propertiesFromGlobalFile == null) {
            return null;
        }
        int cleanVersion = propertiesFromGlobalFile.getInt(ZOOKEEPER_UPGRADE_CLEAN, 0);
        if (cleanVersion == 2) {
            log.debug("Zookeeper migration cleanup to version {} has been done. No need to clean again.", (Object)2);
            return null;
        }
        PropertiesConfiguration cleaned = PropertiesConfigurationFactory.make();
        cleaned.copy((Configuration)propertiesFromGlobalFile);
        cleaned.setProperty(ZOOKEEPER_UPGRADE_CLEAN, (Object)2);
        for (String key : this.ignoredPropertyKeySet) {
            if (cleaned.getProperty(key) == null) continue;
            log.warn("Zookeeper migration cleanup,  clearing key {}.", (Object)key);
            cleaned.clearProperty(key);
        }
        return cleaned;
    }

    private PropertiesConfiguration checkAndLoadZookeeperSnapshot() {
        File[] fileList;
        if (!ConfigurationUtils.isCMEnabled()) {
            log.debug("CM not installed, so do not attempt zookeeper migration");
            return null;
        }
        File fData = new File(this.zkDataFilePath);
        if (!fData.exists()) {
            log.info("no Zookeeper snapshots found, nothing to migrate");
            return null;
        }
        HashMap<String, String[]> zkProperties = new HashMap<String, String[]>();
        for (File file : fileList = fData.listFiles()) {
            if (!file.isFile() || !file.getName().startsWith(ZOOKEEPER_SNAPSHOT_PREFIX)) continue;
            this.loadSnapshot(zkProperties, file);
        }
        PropertiesConfiguration propConfig = PropertiesConfigurationFactory.make();
        for (String name : zkProperties.keySet()) {
            String[] value = zkProperties.get(name);
            if (value == null || value.length != 2) continue;
            propConfig.setProperty(name, (Object)value[1]);
        }
        return propConfig;
    }

    private void loadSnapshot(HashMap<String, String[]> zkProperties, File file) {
        try {
            CheckedInputStream is = new CheckedInputStream(new BufferedInputStream(new FileInputStream(file)), new Adler32());
            BinaryInputArchive ia = BinaryInputArchive.getArchive((InputStream)is);
            FileSnap fileSnap = new FileSnap(null);
            DataTree dataTree = new DataTree();
            HashMap sessions = new HashMap();
            fileSnap.deserialize(dataTree, sessions, (InputArchive)ia);
            this.loadZNodeDetails(zkProperties, dataTree, "/");
        }
        catch (Exception e) {
            log.warn("loadSnapshot() - Exception ", (Throwable)e);
        }
    }

    boolean shouldIgnore(String propname) {
        if (propname != null) {
            String name = propname;
            int idxLang = propname.indexOf("_");
            if (idxLang > 0) {
                name = propname.substring(0, idxLang);
            }
            return this.ignoredPropertyKeySet.contains(name);
        }
        return false;
    }

    private void loadZNodeDetails(HashMap<String, String[]> zkProperties, DataTree dataTree, String name) {
        Set children;
        DataNode n = dataTree.getNode(name);
        if (name.startsWith(GLOBAL_CONFIG_PATH)) {
            String[] curData = this.loadZKData(n, dataTree, name);
            String propName = name.substring(GLOBAL_CONFIG_PATH.length());
            if (!this.shouldIgnore(propName)) {
                if (zkProperties.get(propName) != null) {
                    String[] listData = zkProperties.get(propName);
                    if (Integer.valueOf(curData[0]) > Integer.valueOf(listData[0])) {
                        zkProperties.put(propName, curData);
                    }
                } else {
                    zkProperties.put(propName, curData);
                }
            }
        }
        if ((children = n.getChildren()) != null) {
            for (String child : children) {
                this.loadZNodeDetails(zkProperties, dataTree, name + (name.equals("/") ? "" : "/") + child);
            }
        }
    }

    private String[] loadZKData(DataNode n, DataTree dataTree, String name) {
        String[] dataSet = new String[2];
        StatPersisted statpers = n.stat;
        dataSet[0] = String.valueOf(statpers.getVersion());
        Stat stat = new Stat();
        try {
            byte[] zdata = dataTree.getData(name, stat, null);
            dataSet[1] = zdata != null ? new String(zdata) : "";
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("loadZKData - NoNodeException ", (Throwable)e);
            dataSet[1] = "";
        }
        return dataSet;
    }
}

