/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.startupbridge;

import com.ibm.bi.config.ConfigConstants;
import com.ibm.bi.config.util.ConfigurationUtils;
import com.ibm.bi.config.util.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StartupXML
extends ConfigConstants {
    private static final Logger LOG = LoggerFactory.getLogger(StartupXML.class);
    private static final String COGSTARTUP_FILENAME = "configuration/cogstartup.xml";
    private static StartupXML _instance = null;
    private String m_cogstartupFullPath = ConfigurationUtils.resolvePath((String)"configuration/cogstartup.xml");

    public static StartupXML getInstance() {
        if (_instance == null) {
            _instance = new StartupXML();
        }
        return _instance;
    }

    public synchronized void updateCogStartup(String configname, String configstr) {
        if (StringUtils.isBlank((String)configname)) {
            LOG.error("updateCogStartup - config name is empty, no update will be done in cogstartup.xml.");
            return;
        }
        File cogstartupFile = new File(this.m_cogstartupFullPath);
        Document cogstartupdoc = XMLUtils.load((File)cogstartupFile);
        if (cogstartupdoc == null) {
            LOG.error("updateCogStartup - Unable to load cogstartup.xml file, failed updating cogstartup.xml file.");
            return;
        }
        if (configname.equalsIgnoreCase("AAA")) {
            LOG.info("updateCogStartup - start updating cogstartup.xml for config setting {}", (Object)configname);
            if (this.updateAAAInfo(cogstartupdoc, configstr) && this.backupFile(cogstartupFile) && XMLUtils.serialize((Document)cogstartupdoc, (File)cogstartupFile)) {
                LOG.info("updateCogStartup - cogstartup.xml is updated for config setting {}.", (Object)configname);
                return;
            }
        }
        LOG.error("updateCogStartup - The cogstartup.xml is not updated for config setting {}.", (Object)configname);
    }

    public String getAuthProviders(String aaaparamstr) {
        Element providersElem;
        Element orginputaaaElem = XMLUtils.getDocElementFromXMLString((String)aaaparamstr);
        if (orginputaaaElem == null) {
            LOG.error("getAuthProviders - the input AAA param string is not valid.");
            return null;
        }
        Element valueElem = XMLUtils.getChildElement((Element)orginputaaaElem, (String)"crn:value", null);
        if (valueElem != null && (providersElem = XMLUtils.getChildElement((Element)valueElem, (String)"crn:instances", (String)"authProvider")) != null) {
            return XMLUtils.serializeToString((Element)providersElem);
        }
        LOG.error("getAuthProviders - the input AAA value string is not valid.");
        return null;
    }

    public String buildAAAsettings(String aaavaluestr) {
        String openElemStr = "<crn:parameter name=\"AAA\" opaque=\"true\">";
        String closeElemStr = "</crn:parameter>";
        Element orginputValueElem = XMLUtils.getDocElementFromXMLString((String)aaavaluestr);
        if (orginputValueElem == null) {
            LOG.error("buildAAAsettings - the input AAA value string is not valid.");
            return null;
        }
        return openElemStr + aaavaluestr + closeElemStr;
    }

    public String deleteAuthProviders(String aaaparamstr, String nsid) {
        Element orginputaaaElem = XMLUtils.getDocElementFromXMLString((String)aaaparamstr);
        if (orginputaaaElem == null) {
            LOG.error("deleteAuthProviders - the input AAA string is not valid.");
            return null;
        }
        Element valueElem = XMLUtils.getChildElement((Element)orginputaaaElem, (String)"crn:value", null);
        if (valueElem == null) {
            LOG.error("deleteAuthProviders - the input AAA value string is not valid.");
            return null;
        }
        Element authProviderElem = XMLUtils.getChildElement((Element)valueElem, (String)"crn:instances", (String)"authProvider");
        if (authProviderElem == null) {
            LOG.error("deleteAuthProviders - the input AAA crn:instances is not valid or empty.");
            return null;
        }
        NodeList instanceList = authProviderElem.getElementsByTagName("crn:instance");
        boolean bFound = false;
        Element nsElem = this.getInstanceByIDValue(instanceList, nsid);
        if (nsElem != null) {
            bFound = true;
            authProviderElem.removeChild(nsElem);
        }
        if (!bFound) {
            return null;
        }
        return XMLUtils.serializeToString((Element)orginputaaaElem);
    }

    public Element getInstanceByIDValue(NodeList instanceList, String idValue) {
        Element instance = null;
        for (int i = 0; i < instanceList.getLength(); ++i) {
            Element valueElem;
            instance = (Element)instanceList.item(i);
            Element paramElem = XMLUtils.getChildElement((Element)instance, (String)"crn:parameter", (String)"id");
            if (paramElem == null || !(valueElem = XMLUtils.getChildElement((Element)paramElem, (String)"crn:value", null)).getTextContent().equals(idValue)) continue;
            return instance;
        }
        return null;
    }

    private boolean replaceAAAWithXMLString(Document cogdoc, String newAAAsettings) {
        LOG.debug("replaceAAAWithXMLString - start...");
        Element orginputAAAElem = XMLUtils.getDocElementFromXMLString((String)newAAAsettings);
        Element inputAAAElem = null;
        if (orginputAAAElem == null) {
            LOG.error("replaceAAAWithXMLString - new AAA setting string is invalid, return false.");
            return false;
        }
        inputAAAElem = (Element)cogdoc.importNode(orginputAAAElem, true);
        Element rootParamElem = cogdoc.getDocumentElement();
        if (rootParamElem != null) {
            Element aaaParamElem = XMLUtils.getChildElement((Element)rootParamElem, (String)"crn:parameter", (String)"AAA");
            if (aaaParamElem != null) {
                LOG.debug("replaceAAAWithXMLString - remove original AAA ");
                rootParamElem.removeChild(aaaParamElem);
            }
            rootParamElem.appendChild(inputAAAElem);
            LOG.debug("replaceAAAWithXMLString - append new AAA, return true.");
            return true;
        }
        LOG.debug("replaceAAAWithXMLString - invalid cogstartup doc, return false.");
        return false;
    }

    private boolean updateAAAInfo(Document cogdoc, String AAAinfo) {
        return this.replaceAAAWithXMLString(cogdoc, AAAinfo);
    }

    public boolean backupFile(File file) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
        String timeStamp = formatter.format(new Date());
        String curfilename = file.getAbsolutePath();
        if (file.exists()) {
            String newfilename = curfilename + "_" + timeStamp;
            File backupFile = new File(newfilename);
            try {
                Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (IOException e) {
                LOG.error("Unable to back up file '" + curfilename + "'. - " + e.toString());
                return false;
            }
        }
        LOG.error("Unable to back up. The file '" + curfilename + "' doesn't exist.");
        return false;
    }

    public boolean validateAAAXMLString(String AAAsettings) {
        Element inputaaaElem = XMLUtils.getDocElementFromXMLString((String)AAAsettings);
        if (inputaaaElem == null) {
            LOG.error("validateAAAXMLString - the input AAA param string is not valid.");
            return false;
        }
        String rootname = inputaaaElem.getTagName();
        String nameattr = inputaaaElem.getAttribute("name");
        if (!StringUtils.contains((String)rootname, (String)"parameter") || !StringUtils.equals((String)nameattr, (String)"AAA")) {
            LOG.error("validateAAAXMLString - the input AAA xml string is not valid with tagname={}, name attribute={}", (Object)rootname, (Object)nameattr);
            return false;
        }
        Element valueElem = XMLUtils.getChildElement((Element)inputaaaElem, (String)"crn:value", null);
        if (valueElem == null) {
            LOG.error("validateAAAXMLString - the input AAA xml string is not valid, no value element. ");
            return false;
        }
        return true;
    }
}

