/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.ibm.bi.config.external.CheckedFileOutputStream;
import com.ibm.bi.config.external.CheckedInputStreamFilter;
import com.ibm.bi.config.external.flipper.ResourceConverter;
import com.ibm.bi.config.util.PropertiesConfigurationFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PropertiesConfigurationConverter
implements ResourceConverter<PropertiesConfiguration> {
    @Override
    public PropertiesConfiguration load(InputStream is) throws Exception {
        PropertiesConfiguration pc = PropertiesConfigurationFactory.make();
        try (CheckedInputStreamFilter checked = new CheckedInputStreamFilter(is);){
            pc.load((InputStream)checked);
        }
        return pc;
    }

    @Override
    public InputStream asStream(PropertiesConfiguration propertiesConfiguration) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CheckedOutputStream cos = new CheckedOutputStream(baos, new CRC32());
        OutputStreamWriter writer = new OutputStreamWriter(cos);
        propertiesConfiguration.getLayout().setLineSeparator("\n");
        propertiesConfiguration.getLayout().setGlobalSeparator("=");
        propertiesConfiguration.save((Writer)writer);
        ((Writer)writer).close();
        long checkSum = cos.getChecksum().getValue();
        byte[] header = CheckedFileOutputStream.makeHeader((long)checkSum);
        return new SequenceInputStream(new ByteArrayInputStream(header), new ByteArrayInputStream(baos.toByteArray()));
    }
}

