/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.http;

import com.ibm.bi.platform.commons.http.BIHttpClientCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.client.NoopUserTokenHandler;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BIHttpClientPool {
    private Logger log = null;
    private int maxConnections = Integer.getInteger("BIHttpClientPool.maxConnections", 5000);
    private int poolTTLSeconds = Integer.getInteger("BIHttpClientPool.poolTTLSeconds", 60);
    private int connectTimeout = Integer.getInteger("BIHttpClientPool.connectTimeoutMS", 30000);
    private int requestTimeout = Integer.getInteger("BIHttpClientPool.requestTimeoutMS", 30000);
    private int socketTimeout = Integer.getInteger("BIHttpClientPool.socketTimeoutMS", 300000);
    private static Pattern kaPattern = Pattern.compile("^((\\d+)h)?((\\d+)m)?((\\d+)s)?$");
    private long keepAliveSeconds;
    private ScheduledExecutorService execSvc = null;
    private ScheduledFuture<?> staleMonitorFuture = null;
    private SSLConnectionSocketFactory sslsf = null;
    private CloseableHttpClient httpClient = null;
    private PoolingHttpClientConnectionManager connectionMgr = null;
    private HttpCacheStorage clientCache = new BIHttpClientCache();
    private ResourceFactory resourceFactory = null;
    private String context = null;
    private RedirectStrategy redirectStrategy = LaxRedirectStrategy.INSTANCE;
    private HttpRoutePlanner routePlanner = null;

    public void initialize(String context) {
        this.context = context;
        this.clientCache = new BIHttpClientCache(context);
        this.initialize();
    }

    public void initialize(HttpCacheStorage clientCache) {
        this.initialize(clientCache, null);
    }

    public void initialize(HttpCacheStorage clientCache, ResourceFactory factory) {
        this.clientCache = clientCache;
        this.resourceFactory = factory;
        this.initialize();
    }

    public void initialize(String context, boolean followRedirects) {
        this.context = context;
        this.initialize(followRedirects);
    }

    @PostConstruct
    public void initialize() {
        this.initialize(true);
    }

    long getDefaultKeepAliveSeconds() {
        try {
            long secs = 0L;
            String part = null;
            Matcher matcher = kaPattern.matcher(this.getPersistTimeout());
            if (matcher.matches()) {
                part = matcher.group(2);
                secs += StringUtils.isNotEmpty((String)part) ? Long.parseLong(part) * 3600L : 0L;
                part = matcher.group(4);
                secs += StringUtils.isNotEmpty((String)part) ? Long.parseLong(part) * 60L : 0L;
                part = matcher.group(6);
                return secs += StringUtils.isNotEmpty((String)part) ? Long.parseLong(part) : 0L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLogger().warn("invalid 'persist.timeout': {}", (Object)System.getProperty("persist.timeout"));
        return 30L;
    }

    CharSequence getPersistTimeout() {
        return System.getProperty("persist.timeout");
    }

    public void initialize(String context, boolean followRedirects, HttpRoutePlanner routePlanner) {
        this.context = context;
        this.routePlanner = routePlanner;
        this.initialize(followRedirects);
    }

    public void initialize(String context, RedirectStrategy redirectStrategy) {
        this.context = context;
        this.redirectStrategy = redirectStrategy;
        this.initialize(true);
    }

    public void initialize(boolean followRedirects) {
        if (this.connectionMgr == null || this.httpClient == null) {
            this.sslsf = this.getSSLSocketFactory();
            this.connectionMgr = this.sslsf != null ? new PoolingHttpClientConnectionManager(this.getRegistry(), null, null, null, (long)this.poolTTLSeconds, TimeUnit.SECONDS) : new PoolingHttpClientConnectionManager((long)this.poolTTLSeconds, TimeUnit.SECONDS);
            this.connectionMgr.setDefaultMaxPerRoute(this.maxConnections / 4);
            this.connectionMgr.setMaxTotal(this.maxConnections);
            this.monitorForStaleConnections();
            this.httpClient = this.buildClient(followRedirects);
        }
        this.keepAliveSeconds = this.getDefaultKeepAliveSeconds();
    }

    private void monitorForStaleConnections() {
        this.staleMonitorFuture = this.getExecSvc().scheduleWithFixedDelay(new IdleConnectionMonitor((HttpClientConnectionManager)this.connectionMgr), 5L, 5L, TimeUnit.SECONDS);
    }

    private ScheduledExecutorService getExecSvc() {
        if (this.execSvc == null) {
            try {
                this.execSvc = (ManagedScheduledExecutorService)new InitialContext().lookup("concurrent/biScheduledExecSvc");
            }
            catch (NamingException e) {
                this.getLogger().error("failed to get concurrent/biScheduledExecSvc", (Throwable)e);
                this.execSvc = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "BIHttpConnectionPoolCleaner-" + BIHttpClientPool.this.context);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
        }
        return this.execSvc;
    }

    CloseableHttpClient buildClient(boolean followRedirects) {
        RequestConfig reqConfig = this.buildRequestConfig(RequestConfig.custom());
        CacheConfig cacheConfig = this.buildCacheConfig(CacheConfig.custom());
        ConnectionKeepAliveStrategy keepAliveStrategy = this.buildKeepAliveStrategy();
        return this.buildClient(reqConfig, cacheConfig, this.getCacheClientBuilder(cacheConfig), keepAliveStrategy, followRedirects);
    }

    protected HttpClientBuilder getCacheClientBuilder(CacheConfig cacheConfig) {
        CachingHttpClientBuilder builder = CachingHttpClients.custom().setCacheConfig(cacheConfig).setHttpCacheStorage(this.clientCache);
        if (this.resourceFactory != null) {
            builder.setResourceFactory(this.resourceFactory);
        }
        return builder;
    }

    RequestConfig buildRequestConfig(RequestConfig.Builder builder) {
        return builder.setCookieSpec("ignoreCookies").setConnectionRequestTimeout(this.requestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return BIHttpClientPool.this.keepAliveSeconds;
            }
        };
    }

    CacheConfig buildCacheConfig(CacheConfig.Builder builder) {
        return builder.setMaxCacheEntries(BIHttpClientCache.maxCacheEntries).setMaxObjectSize(BIHttpClientCache.maxCacheObjectSize).build();
    }

    CloseableHttpClient buildClient(RequestConfig reqConfig, CacheConfig cacheConfig, HttpClientBuilder builder, ConnectionKeepAliveStrategy keepAliveStrategy, boolean followRedirects) {
        builder = builder.setConnectionManager((HttpClientConnectionManager)this.connectionMgr).setDefaultRequestConfig(reqConfig).setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler()).setKeepAliveStrategy(keepAliveStrategy).setUserTokenHandler((UserTokenHandler)new NoopUserTokenHandler());
        if (this.sslsf != null) {
            builder = builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslsf);
        }
        if (!followRedirects) {
            builder = builder.disableRedirectHandling();
        } else if (this.redirectStrategy != null) {
            builder.setRedirectStrategy(this.redirectStrategy);
        }
        if (this.routePlanner != null) {
            builder.setRoutePlanner(this.routePlanner);
        }
        return builder.build();
    }

    public void setDisableRedirectHandling() {
        this.httpClient = this.buildClient(false);
    }

    @PreDestroy
    public void terminate() {
        if (this.staleMonitorFuture != null) {
            this.staleMonitorFuture.cancel(true);
            this.staleMonitorFuture = null;
        }
        if (this.execSvc != null && !(this.execSvc instanceof ManagedExecutorService)) {
            this.execSvc.shutdownNow();
            this.execSvc = null;
        }
        if (this.connectionMgr != null) {
            this.connectionMgr.shutdown();
            this.connectionMgr = null;
        }
        this.httpClient = null;
    }

    public CloseableHttpClient getClient() {
        if (this.connectionMgr == null || this.httpClient == null) {
            throw new IllegalStateException("Connection pool not initialized");
        }
        this.getLogger().trace(this.connectionMgr.getTotalStats().toString());
        return this.httpClient;
    }

    protected SSLConnectionSocketFactory getSSLSocketFactory() {
        try {
            Class<?> c = Class.forName("com.ibm.bi.platform.commons.crypto.JCAMCrypto");
            Method m = c.getMethod("getSSLConnectionSocketFactory", null);
            this.getLogger().debug("CAMCrypto SSL enabled in connection socket factory");
            return (SSLConnectionSocketFactory)m.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            this.getLogger().debug("Default SSL enabled in connection socket factory");
            return null;
        }
    }

    protected Registry<ConnectionSocketFactory> getRegistry() {
        RegistryBuilder regBuilder = RegistryBuilder.create();
        regBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (this.sslsf != null) {
            regBuilder.register("https", (Object)this.sslsf);
        }
        return regBuilder.build();
    }

    protected PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionMgr;
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger((String)(this.getClass().getName() + (this.context != null ? "." + this.context : "")));
        }
        return this.log;
    }

    private class IdleConnectionMonitor
    implements Runnable {
        private final HttpClientConnectionManager connMgr;

        public IdleConnectionMonitor(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        @Override
        public void run() {
            try {
                this.connMgr.closeExpiredConnections();
                this.connMgr.closeIdleConnections(BIHttpClientPool.this.keepAliveSeconds, TimeUnit.SECONDS);
                if (BIHttpClientPool.this.getLogger().isDebugEnabled()) {
                    BIHttpClientPool.this.getLogger().debug(((PoolingHttpClientConnectionManager)this.connMgr).getTotalStats().toString());
                }
            }
            catch (Exception ex) {
                BIHttpClientPool.this.getLogger().error("Unexpected exception in IdleConnectionMonitor", (Throwable)ex);
            }
        }
    }
}

