/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.commons.http.util;

import com.ibm.bi.platform.commons.crypto.JCAMCryptoConfiguration;
import com.ibm.bi.platform.commons.http.util.LocalAddresses;
import com.ibm.bi.rest.RESTClient;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOGGER;
    public static final HeaderGroup hopByHopHeaders;
    private static SecureRandom random;

    public static String getDefaultAddress() {
        return StringUtils.substringBefore((String)JCAMCryptoConfiguration.getProvider().getInternalDispatcher(), (String)"/p2pd");
    }

    public static String getServerName() {
        String externalDispatcher = HttpUtils.getExternalDispatcher();
        try {
            URL edUrl = new URL(externalDispatcher);
            if (edUrl.getHost().equalsIgnoreCase("localhost")) {
                externalDispatcher = new URL(edUrl.getProtocol(), LocalAddresses.getHostName(), edUrl.getPort(), edUrl.getPath()).toString();
            }
        }
        catch (MalformedURLException e) {
            LOGGER.error("Error creating URL", (Throwable)e);
        }
        return externalDispatcher.toLowerCase();
    }

    protected static String getExternalDispatcher() {
        return JCAMCryptoConfiguration.getProvider().getExternalDispatcher().replaceAll("/p2pd.*", "");
    }

    public static String encodePathInfo(String pathInfo) {
        StringJoiner sj = new StringJoiner("/", "/", pathInfo.endsWith("/") ? "/" : "");
        Arrays.asList(pathInfo.split("/")).forEach(part -> {
            if (StringUtils.isNotEmpty((String)part)) {
                sj.add(HttpUtils.urlEncode(part));
            }
        });
        return sj.toString();
    }

    public static String urlEncode(String part) {
        try {
            return StringUtils.replace((String)URLEncoder.encode(part, "UTF-8"), (String)"+", (String)"%20").toString();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("error encoding part: {}", (Object)part, (Object)e);
            return "";
        }
    }

    public static String urlDecode(String part) {
        try {
            return URLDecoder.decode(part, "UTF-8").toString();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("error decoding part: {}", (Object)part, (Object)e);
            return "";
        }
    }

    public static String buildQueryString(HttpServletRequest request) {
        String qs = request.getQueryString();
        if (StringUtils.isNotEmpty((String)qs)) {
            return "?" + qs;
        }
        return "";
    }

    public static void copyResponseHeaders(RESTClient client, HttpServletResponse resp) {
        Header[] headers = client.getResponseHeaders();
        if (headers != null) {
            for (Header header : headers) {
                if (hopByHopHeaders.containsHeader(header.getName())) continue;
                resp.addHeader(header.getName(), header.getValue());
            }
        }
    }

    public static String generateNewXSRFToken() {
        int xsrfTokenSize = 24;
        byte[] xsrfBytes = new byte[24];
        random.nextBytes(xsrfBytes);
        return Base64.getUrlEncoder().encodeToString(xsrfBytes);
    }

    public static URL getCAEndpoint(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String header = request.getHeader("x-ca-endpoint");
        if (StringUtils.isBlank((String)header)) {
            return null;
        }
        try {
            return new URL(header);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Bad x-ca-endpoint header: {}", (Object)e.getMessage());
            return null;
        }
    }

    static {
        String[] headers;
        LOGGER = LoggerFactory.getLogger(HttpUtils.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "X-CA-XSSEncoded"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        random = new SecureRandom();
    }
}

