/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.rs;

import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.CommonsMessageKeys;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.bi.rs.BaseContainerRequestFilter;
import com.ibm.bi.rs.IAdminFilter;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@IAdminFilter
public class AdminFilter
extends BaseContainerRequestFilter
implements ContainerRequestFilter {
    public static final String IS_SYSTEM_ADMIN = "isSystemAdmin";
    public static final String IS_TENANT_ADMIN = "isTenantAdmin";
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminFilter.class);
    private static final boolean disabled = Boolean.getBoolean("AdminFilter.disable");
    @Context
    protected ResourceInfo resourceInfo;
    @Context
    private HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!disabled) {
            boolean check4TA = this.hasTenantAnnotation();
            JsonObject me = this.getMe(requestContext);
            if (me != null) {
                if (me.getBoolean(IS_SYSTEM_ADMIN).booleanValue()) {
                    requestContext.setProperty(IS_SYSTEM_ADMIN, (Object)true);
                    return;
                }
                if (check4TA && me.getBoolean(IS_TENANT_ADMIN).booleanValue()) {
                    requestContext.setProperty(IS_TENANT_ADMIN, (Object)true);
                    return;
                }
                LOGGER.error("User {} is not a member of {} Administrators", (Object)me.getString("userName"), (Object)(check4TA ? "Tenant" : "System"));
                if (this.abort()) {
                    requestContext.abortWith(this.abortResponse(CommonsMessageKeys.administrator_user.buildMessage().getLocalizedMessage()));
                }
            } else {
                LOGGER.error("Error retrieving 'me' resource.");
                if (this.abort()) {
                    requestContext.abortWith(this.abortResponse(CommonsMessageKeys.error_user.buildMessage().getLocalizedMessage()));
                }
            }
        }
    }

    JsonObject getMe(ContainerRequestContext requestContext) {
        JsonObject me = null;
        try (RESTClient client = RESTClientFactory.getInstance().getClient(this.servletRequest);){
            me = client.getResource("/bi/v1/me", "application/json");
        }
        catch (Exception e) {
            LOGGER.error("error", (Throwable)e);
        }
        return me;
    }

    protected Response abortResponse(String message) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)message).header("Content-Type", (Object)"text/plain").build();
    }

    boolean abort() {
        IAdminFilter af = (IAdminFilter)this.getEffectiveAnnotation(IAdminFilter.class);
        if (af != null) {
            return af.abort();
        }
        return true;
    }

    boolean hasTenantAnnotation() {
        IAdminFilter af = (IAdminFilter)this.getEffectiveAnnotation(IAdminFilter.class);
        if (af != null) {
            return af.tenantAdmin();
        }
        return false;
    }
}

