/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.annotation.Async;
import com.ibm.bi.content.apps.resources.filters.ContentMetrics;

@Async(period=30L, scheduleType=Async.ScheduleType.FIXED_DELAY, initialState=Async.InitialState.HEALTHY, initialDelay=180L)
public class CSHealthCheck
extends HealthCheck {
    private ContentMetrics metrics;

    CSHealthCheck(ContentMetrics metrics) {
        this.metrics = metrics;
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result response = this.isContentServiceHealthy() ? this.healthyResponse().build() : this.unHealthyResponse().build();
        this.metrics.resetCounters();
        return response;
    }

    protected boolean isContentServiceHealthy() {
        if (this.metrics.getTotalRequests() > 0L) {
            long threshold = (long)((double)this.metrics.getTotalRequests() * 0.8);
            if (this.metrics.getFailedRequests() > threshold) {
                return false;
            }
        }
        return true;
    }

    private HealthCheck.ResultBuilder healthyResponse() {
        return HealthCheck.Result.builder().healthy().withMessage("Content-Service is running ok!").withDetail("Average Request Time", (Object)this.avgRequestTime());
    }

    private HealthCheck.ResultBuilder unHealthyResponse() {
        return HealthCheck.Result.builder().unhealthy().withMessage("More than 80% of the Content-Service requests were failed in the last 30 seconds.").withDetail("Average Request Time", (Object)this.avgRequestTime());
    }

    private String avgRequestTime() {
        return String.format("%.2fseconds, in the last 30 seconds for %d requests", this.metrics.getMeanRequestTimeinSeconds(), this.metrics.getTotalRequests());
    }
}

