/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import com.cognos.accman.autoca.RequestHandler;
import com.cognos.accman.autoca.XmlCaError;
import com.cognos.accman.autoca.XmlCaResponse;
import com.cognos.accman.autoca.XmlCertRequest;
import com.cognos.accman.autoca.XmlCertResponse;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapperException;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.res.MessageSet;
import java.security.cert.Certificate;

public class CertRequestHandler
implements RequestHandler {
    private XmlCertRequest certRequest = null;

    public CertRequestHandler(XmlCertRequest newCertRequest) {
        this.certRequest = newCertRequest;
    }

    @Override
    public String process() {
        Configuration config = Configuration.getInstance();
        XmlCaResponse caResponse = new XmlCaResponse();
        boolean bCompareHMAC = false;
        boolean bIsPreviousFormat = false;
        try {
            byte[] properHMAC;
            String base64properHMAC;
            byte[] properShaHMAC;
            String base64properShaHMAC;
            String hmacAlgorithm = this.certRequest.hmacAlgorithm;
            if (hmacAlgorithm == null || hmacAlgorithm.length() == 0) {
                bIsPreviousFormat = true;
            }
            bCompareHMAC = bIsPreviousFormat ? this.certRequest.shaHMAC.compareTo(base64properShaHMAC = new String(CryptoWrapper.encodeBase64(properShaHMAC = CryptoWrapper.calculateHMAC(this.certRequest.pkcs10data.getBytes(), config.getCAPassword())))) == 0 : this.certRequest.hmac.compareTo(base64properHMAC = new String(CryptoWrapper.encodeBase64(properHMAC = CryptoWrapper.calculateHMAC(this.certRequest.pkcs10data.getBytes(), config.getCAPassword(), hmacAlgorithm)))) == 0;
        }
        catch (CryptoWrapperException cge) {
            XmlCaError caError = new XmlCaError();
            caError.addError(cge.toString());
            caResponse.setResponse(caError);
            return caResponse.toString();
        }
        catch (CAMCryptoException cce) {
            XmlCaError caError = new XmlCaError();
            caError.addError(cce.toString());
            caResponse.setResponse(caError);
            return caResponse.toString();
        }
        if (bCompareHMAC) {
            try {
                byte[] pkcs10data = CryptoWrapper.decodeBase64(this.certRequest.pkcs10data.getBytes());
                Certificate reqCert = CryptoWrapper.generateCertificate(pkcs10data, KeyStoreReader.getCACertificate(), KeyStoreReader.getCAPrivateKey());
                XmlCertResponse certResponse = new XmlCertResponse();
                certResponse.requestedCert = new String(CryptoWrapper.encodeBase64(reqCert.getEncoded()));
                certResponse.caCert = new String(CryptoWrapper.encodeBase64(KeyStoreReader.getCACertificate().getEncoded()));
                if (bIsPreviousFormat) {
                    byte[] responseHMAC = CryptoWrapper.calculateHMAC((certResponse.requestedCert + certResponse.caCert).getBytes(), config.getCAPassword());
                    certResponse.shaHMAC = new String(CryptoWrapper.encodeBase64(responseHMAC));
                } else {
                    String hmacAlgorithm = config.getConfiguredHMACAlgorithm();
                    byte[] responseHMAC = CryptoWrapper.calculateHMAC((certResponse.requestedCert + certResponse.caCert).getBytes(), config.getCAPassword(), hmacAlgorithm);
                    certResponse.hmac = new String(CryptoWrapper.encodeBase64(responseHMAC));
                    certResponse.hmacAlgorithm = hmacAlgorithm;
                }
                caResponse.setResponse(certResponse);
            }
            catch (Exception e) {
                XmlCaError caError = new XmlCaError();
                caError.addError(e.toString());
                caResponse.setResponse(caError);
            }
        } else {
            XmlCaError caError = new XmlCaError();
            caError.addError(MessageSet.getMessage("CAM_CRP_autoca_password_mismatch"));
            caResponse.setResponse(caError);
        }
        return caResponse.toString();
    }

    @Override
    public void postprocess() {
    }
}

