/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import com.cognos.accman.autoca.XmlCaError;
import com.cognos.accman.autoca.XmlCertResponse;
import com.cognos.accman.autoca.XmlPingResponse;
import com.cognos.accman.autoca.XmlStopResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlCaResponse {
    private Object response;

    public void setResponse(Object newResponse) {
        this.response = newResponse;
    }

    public Object getResponse() {
        return this.response;
    }

    public boolean getIsErrorResponse() {
        return this.response instanceof XmlCaError;
    }

    public static XmlCaResponse fromString(String xmlStr) {
        XmlCaResponse newCaResponse = new XmlCaResponse();
        try {
            Document domDoc = DocumentHelper.parseText((String)xmlStr);
            Element rootElem = domDoc.getRootElement();
            if (rootElem.getNamespaceURI().compareTo("http://developer.cognos.com/schemas/autoCAService/1/") != 0 || rootElem.getName().compareTo("caResponse") != 0) {
                return null;
            }
            Element responseElem = (Element)rootElem.elements().get(0);
            if (responseElem.getName().equals("certResponse")) {
                newCaResponse.response = XmlCertResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("stopResponse")) {
                newCaResponse.response = XmlStopResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("pong")) {
                newCaResponse.response = XmlPingResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("error")) {
                newCaResponse.response = XmlCaError.fromElement(responseElem);
            }
        }
        catch (DocumentException de) {
            return null;
        }
        return newCaResponse;
    }

    public static XmlCaResponse fromBibusString(String xmlStr) {
        XmlCaResponse newCaResponse = new XmlCaResponse();
        try {
            Document domDoc = DocumentHelper.parseText((String)xmlStr);
            Node certResNode = domDoc.selectSingleNode("/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='caResponse']");
            if (certResNode == null) {
                return null;
            }
            String certResStr = certResNode.asXML();
            Document certResDoc = DocumentHelper.parseText((String)certResStr);
            Element rootElem = certResDoc.getRootElement();
            if (rootElem.getNamespaceURI().compareTo("http://developer.cognos.com/schemas/autoCAService/1/") != 0 || rootElem.getName().compareTo("caResponse") != 0) {
                return null;
            }
            Element responseElem = (Element)rootElem.elements().get(0);
            if (responseElem.getName().equals("certResponse")) {
                newCaResponse.response = XmlCertResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("stopResponse")) {
                newCaResponse.response = XmlStopResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("pong")) {
                newCaResponse.response = XmlPingResponse.fromElement(responseElem);
            } else if (responseElem.getName().equals("error")) {
                newCaResponse.response = XmlCaError.fromElement(responseElem);
            }
        }
        catch (DocumentException de) {
            return null;
        }
        return newCaResponse;
    }

    public String toString() {
        return "<caResponse xmlns=\"http://developer.cognos.com/schemas/autoCAService/1/\">" + this.response + "</" + "caResponse" + ">";
    }
}

