/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.res.MessageSet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DeploymentCipherStreamSession {
    public static int m_version = 5;
    private static String dcssVersion_5 = "Created by: COGNOS ReportNet Deployment Cipher Stream Version 5.0\n";
    private static String dcssVersion_3 = "Created by: COGNOS ReportNet Deployment Cipher Stream Version 3.0\n";
    private static String dcssVersion_2 = "Created by: COGNOS ReportNet Deployment Cipher Stream Version 2.0\n";
    private static final int PBE_SALT_LENGTH = 8;
    private static final int PBE_ITERATION_COUNT = 100;
    private String pwdString = null;
    private boolean useDESKey = false;
    private boolean enableBackwardCompatibleCloseBehavior = true;

    DeploymentCipherStreamSession(byte[] password) throws CAMCryptoException {
        if (password == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_password_nodata"));
        }
        if (password.length == 0) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_invalid_password_nodata"));
        }
        this.pwdString = new String(password);
    }

    public CipherOutputStream createEncryptingOutputStream(OutputStream os) throws CAMCryptoException {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] rawKey = sha.digest(this.pwdString.getBytes());
            rawKey = Arrays.copyOf(rawKey, 16);
            SecretKeySpec sessionDeployKey = new SecretKeySpec(rawKey, 0, 16, "AES");
            Cipher c = Cipher.getInstance("AES", JVMEnvironment.getInstance().getPBEProvider());
            c.init(1, sessionDeployKey);
            CipherOutputStream cos = new CipherOutputStream(os, c);
            String dcssVersionString = this.getDCSSVersionString(m_version);
            os.write(dcssVersionString.getBytes());
            return cos;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
        }
    }

    public CipherOutputStream createEncryptingOutputStreamForTest(OutputStream os) throws CAMCryptoException {
        Cipher c = null;
        try {
            Configuration config = Configuration.getInstance();
            if (this.useDESKey) {
                SecretKey sessionDeployKey = this.generateDESKey(this.pwdString.getBytes());
                c = Cipher.getInstance("DES/ECB/PKCS5Padding", JVMEnvironment.getInstance().getPBEProvider());
                c.init(1, sessionDeployKey);
            } else {
                SecureRandom random = JVMEnvironment.getInstance().getSecureRandom();
                byte[] salt = new byte[8];
                random.nextBytes(salt);
                SecretKey sessionDeployKey = this.generatePBEKey(this.pwdString, m_version);
                PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 100);
                String pbeCipherName = this.getPBECipherName(m_version);
                c = Cipher.getInstance(pbeCipherName, JVMEnvironment.getInstance().getPBEProvider());
                c.init(1, (Key)sessionDeployKey, paramSpec);
                String dcssVersionString = this.getDCSSVersionString(m_version);
                os.write(dcssVersionString.getBytes());
                os.write(salt);
            }
            CipherOutputStream cos = new CipherOutputStream(os, c);
            return cos;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
        }
    }

    public void setEnableBackwardCompatibleCloseBehavior(boolean value) {
        this.enableBackwardCompatibleCloseBehavior = value;
    }

    public CipherInputStream createDecryptingInputStream(InputStream is) throws CAMCryptoException {
        Cipher c = null;
        BufferedInputStream bis = new BufferedInputStream(is);
        bis.mark(0);
        try {
            int len = dcssVersion_5.length();
            byte[] version = new byte[len];
            bis.read(version, 0, len);
            if (0 == dcssVersion_5.compareTo(new String(version))) {
                int ver = 5;
                c = this.getDeploymentCipher(bis, ver);
            } else if (0 == dcssVersion_3.compareTo(new String(version))) {
                int ver = 3;
                c = this.getDeploymentCipher(bis, ver);
            } else if (0 == dcssVersion_2.compareTo(new String(version))) {
                int ver = 2;
                c = this.getDeploymentCipher(bis, ver);
            } else {
                bis.reset();
                SecretKey sessionDeployKey = this.generateDESKey(this.pwdString.getBytes());
                c = Cipher.getInstance("DES/ECB/PKCS5Padding", JVMEnvironment.getInstance().getPBEProvider());
                c.init(2, sessionDeployKey);
            }
            CipherInputStream cis = new CipherInputStream(bis, c);
            if (this.enableBackwardCompatibleCloseBehavior) {
                return new CAMCipherInputStream(cis);
            }
            return cis;
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_no_build_cipher_obj"));
        }
    }

    private Cipher getDeploymentCipher(BufferedInputStream bis, int ver) throws IOException, CAMCryptoException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher c = null;
        if (5 == ver) {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] rawKey = sha.digest(this.pwdString.getBytes());
            rawKey = Arrays.copyOf(rawKey, 16);
            SecretKeySpec sessionDeployKey = new SecretKeySpec(rawKey, 0, 16, "AES");
            c = Cipher.getInstance("AES", JVMEnvironment.getInstance().getPBEProvider());
            c.init(2, sessionDeployKey);
        } else {
            byte[] salt = new byte[8];
            bis.read(salt, 0, 8);
            SecretKey sessionDeployKey = this.generatePBEKey(this.pwdString, ver);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, 100);
            String pbeCipheName = this.getPBECipherName(ver);
            c = Cipher.getInstance(pbeCipheName, JVMEnvironment.getInstance().getPBEProvider());
            c.init(2, (Key)sessionDeployKey, paramSpec);
        }
        return c;
    }

    private SecretKey generateDESKey(byte[] password) throws CAMCryptoException {
        SecretKeyFactory scf = null;
        DESKeySpec ks = null;
        try {
            scf = SecretKeyFactory.getInstance("DES", JVMEnvironment.getInstance().getPBEProvider());
            ks = new DESKeySpec(password, 0);
        }
        catch (InvalidKeyException ike) {
            throw new CAMCryptoException(ike, MessageSet.getMessage("CAM_CRP_invalid_password_length"));
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_missing_des"));
        }
        SecretKey sessionDeployKey = null;
        try {
            sessionDeployKey = scf.generateSecret(ks);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_deployment_cipher_key"));
        }
        return sessionDeployKey;
    }

    private SecretKey generatePBEKey(String password, int ver) throws CAMCryptoException {
        SecretKey sessionDeployKey = null;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
            SecretKeyFactory keyFactory = null;
            String pbeCipheName = this.getPBECipherName(ver);
            keyFactory = SecretKeyFactory.getInstance(pbeCipheName, JVMEnvironment.getInstance().getPBEProvider());
            sessionDeployKey = keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_deployment_cipher_key"));
        }
        return sessionDeployKey;
    }

    public void setUseDESKey(boolean flag) {
        this.useDESKey = flag;
    }

    public void setVersion(int ver) {
        m_version = ver;
    }

    private String getPBECipherName(int ver) throws CAMCryptoException {
        if (3 == ver) {
            return "PBEWithSHA1AndDES";
        }
        if (2 == ver) {
            return "PBEWithMD5AndDES";
        }
        return null;
    }

    private String getDCSSVersionString(int ver) {
        if (5 == ver) {
            return "Created by: COGNOS ReportNet Deployment Cipher Stream Version 5.0\n";
        }
        if (3 == ver) {
            return "Created by: COGNOS ReportNet Deployment Cipher Stream Version 3.0\n";
        }
        if (2 == ver) {
            return "Created by: COGNOS ReportNet Deployment Cipher Stream Version 2.0\n";
        }
        return null;
    }

    private class CAMCipherInputStream
    extends CipherInputStream {
        CAMCipherInputStream(CipherInputStream cis) {
            super(cis);
        }

        @Override
        public void close() throws IOException {
            block2: {
                try {
                    super.close();
                }
                catch (IOException e) {
                    if (e.getCause() instanceof IllegalBlockSizeException || e.getCause() instanceof BadPaddingException) break block2;
                    throw e;
                }
            }
        }
    }
}

