/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.casync.CaFreshnessHandler;
import com.cognos.accman.jcam.crypto.casync.CaSyncHandler;
import com.cognos.accman.jcam.crypto.misc.CAMCSKKeyStore;
import com.cognos.accman.jcam.crypto.misc.CAMCertSHA2Verifier;
import com.cognos.accman.jcam.crypto.misc.CAMCryptoUtilities;
import com.cognos.accman.jcam.crypto.misc.CAMKeyStore;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoWrapper;
import com.cognos.accman.jcam.crypto.misc.EncodedCSK;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.JVMEnvironment;
import com.cognos.accman.jcam.crypto.misc.KeyExpiryChecker;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.res.MessageSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class KeyStoreReader {
    private static KeyStoreManager ksMgr = KeyStoreManager.getInstance();
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    static IPFTraceLogger pkiTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.PKI");
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");

    public static byte[] getEncodedCSKWithExpiryCheck(byte[] digest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        cskTraceLogger.trace("digest input = " + IPFTraceLogger.toBase64String(digest));
        Configuration config = Configuration.getInstance();
        KeyExpiryChecker.checkForCSKExpiry();
        if (config.getWeAreCM() && !KeyStoreWriter.haveSyncedSuccessfully()) {
            KeyStoreWriter.syncCSKKeystoreWithCM();
        }
        try {
            SecretKey csk = null;
            Date date = null;
            if (digest == null) {
                csk = KeyStoreReader.getCSKFromKeystoreOrRemoteServer();
                date = ksMgr.getCSKKeystore().getCreationDate(config.getCSKAlias());
            } else {
                csk = KeyStoreReader.getCSKGivenCSKDigest(digest);
                String CSKAlias = new String(CryptoWrapper.encodeBase64(digest));
                date = ksMgr.getCSKKeystore().getCreationDate(CSKAlias);
                if (date == null) {
                    date = ksMgr.getCSKKeystore().getCreationDate(config.getCSKAlias());
                }
            }
            EncodedCSK ecsk = new EncodedCSK(date, csk);
            cskTraceLogger.logExit(true);
            return ecsk.getEncoded();
        }
        catch (KeyStoreException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        catch (IOException e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
    }

    public static SecretKey getCSKWithExpiryCheck() throws CAMCryptoException {
        SecretKey secretKey;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        KeyExpiryChecker.checkForCSKExpiry();
        if (config.isMDMRunning()) {
            return KeyStoreReader.getCSKFromKeyStore();
        }
        if (config.getWeAreCM() && !KeyStoreWriter.haveSyncedSuccessfully()) {
            KeyStoreWriter.syncCSKKeystoreWithCM();
        }
        if ((secretKey = KeyStoreReader.getCSKFromKeystoreOrRemoteServer()) != null) {
            cskTraceLogger.logExit(true);
        } else {
            cskTraceLogger.logExit();
        }
        return secretKey;
    }

    public static SecretKey getCSKWithoutExpiryCheck() throws CAMCryptoException {
        SecretKey secretKey;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() && !KeyStoreWriter.haveSyncedSuccessfully()) {
            KeyStoreWriter.syncCSKKeystoreWithCM();
        }
        if ((secretKey = KeyStoreReader.getCSKFromKeystoreOrRemoteServer()) != null) {
            cskTraceLogger.logExit(true);
        } else {
            cskTraceLogger.logExit();
        }
        return secretKey;
    }

    public static SecretKey getCSKWithoutExpiryCheckButWithNoRemoteRequest() throws CAMCryptoException {
        SecretKey secretKey;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        if (config.getWeAreCM() && !KeyStoreWriter.haveSyncedSuccessfully()) {
            KeyStoreWriter.syncCSKKeystoreWithCM();
        }
        if ((secretKey = KeyStoreReader.getCSKFromKeyStore()) != null) {
            cskTraceLogger.logExit(true);
        } else {
            cskTraceLogger.logExit();
        }
        return secretKey;
    }

    public static SecretKey getCSKGivenCSKDigest(byte[] requiredCSKDigest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        SecretKey key = KeyStoreReader.getCSKFromKeystoreGivenCSKDigest(requiredCSKDigest);
        if (key != null) {
            return key;
        }
        if (config.getWeAreCM()) {
            KeyStoreWriter.syncCSKKeystoreWithCM();
            key = KeyStoreReader.getCSKFromKeystoreGivenCSKDigest(requiredCSKDigest);
        } else {
            key = KeyStoreWriter.requestAndStoreRemoteCSK(requiredCSKDigest);
        }
        if (key == null) {
            CAMCryptoException e = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_csk_not_found", new String[]{new String(CryptoWrapper.encodeBase64(requiredCSKDigest)), config.getCSKLocation()}));
            cskTraceLogger.logExit(e);
            throw e;
        }
        cskTraceLogger.logExit(true);
        return key;
    }

    private static SecretKey getCSKFromKeystoreGivenCSKDigest(byte[] requiredCSKDigest) throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        try {
            SecretKey currentCSK = KeyStoreReader.getCSKFromKeyStore();
            byte[] cskDigest = CAMCryptoUtilities.digestCSK(currentCSK);
            if (cskDigest.length == requiredCSKDigest.length) {
                boolean digestsMatch = true;
                for (int c = 0; c < requiredCSKDigest.length; ++c) {
                    if (cskDigest[c] == requiredCSKDigest[c]) continue;
                    digestsMatch = false;
                    break;
                }
                if (digestsMatch) {
                    cskTraceLogger.logExit(true);
                    return currentCSK;
                }
            }
        }
        catch (CAMCryptoException currentCSK) {
            // empty catch block
        }
        String requiredCSKAlias = new String(CryptoWrapper.encodeBase64(requiredCSKDigest)).toLowerCase();
        Key key = null;
        try {
            key = ksMgr.getCSKKeystore().getKey(requiredCSKAlias, config.getCSKPassword().toCharArray());
        }
        catch (CAMCryptoException e) {
            cskTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (key != null) {
            cskTraceLogger.logExit(true);
        } else {
            cskTraceLogger.logExit();
        }
        return (SecretKey)key;
    }

    public static SecretKey getCSKFromKeystoreOrRemoteServer() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        SecretKey csk = null;
        try {
            csk = KeyStoreReader.getCSKFromKeyStore();
        }
        catch (CAMCryptoException e) {
            if (config.getWeAreCM()) {
                KeyStoreWriter.syncCSKKeystoreWithCM();
            } else {
                KeyStoreWriter.requestAndStoreRemoteCSK(null);
            }
            csk = KeyStoreReader.getCSKFromKeyStore();
        }
        if (csk != null) {
            cskTraceLogger.logExit(true);
        } else {
            cskTraceLogger.logExit();
        }
        return csk;
    }

    private static SecretKey getCSKFromKeyStore() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Key key = null;
        try {
            key = ksMgr.getCSKKeystore().getKey(config.getCSKAlias(), config.getCSKPassword().toCharArray());
        }
        catch (CAMCryptoException e) {
            cskTraceLogger.logExit(e);
            throw e;
        }
        catch (Exception e) {
            CAMCryptoException cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_read_keystore_error", new String[]{config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (key == null) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_csk_not_found", new String[]{config.getCSKAlias(), config.getCSKLocation()}));
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        cskTraceLogger.logExit(true);
        return (SecretKey)key;
    }

    public static PrivateKey getEncryptionPrivateKey() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        KeyExpiryChecker.checkForEncryptionKeyExpiry();
        PrivateKey key = KeyStoreReader.getEncryptionPrivateKeyFromKeyStore();
        if (key != null) {
            pkiTraceLogger.logExit(true);
        } else {
            pkiTraceLogger.logExit();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getEncryptionPrivateKeyFromKeyStore() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            PrivateKey key = ksMgr.getCAKeystore("encryption").getPrivateKey("encryption");
            if (key == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_encryption_priv_key_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getEncryptionPrivateKey(X500Name recipientIssuerDN, BigInteger recipientSerialNumber) throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            PrivateKey key = ksMgr.getCAKeystore("encryption").getPrivateKey(recipientIssuerDN, recipientSerialNumber);
            if (key == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_encr_priv_key_not_found_in_history"));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] getEncryptionCertificateChain() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate[] certs = ksMgr.getCAKeystore("encryption").getCertificateChain("encryption");
            if (certs == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_enc_cert_chain_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return certs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] getEncryptionX509CertificateChain() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            X509Certificate[] x509certs = ksMgr.getCAKeystore("encryption").getX509CertificateChain("encryption");
            if (x509certs == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_enc_cert_chain_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return x509certs;
        }
    }

    public static Certificate getEncryptionCertificate() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        KeyExpiryChecker.checkForEncryptionKeyExpiry();
        Certificate cert = KeyStoreReader.getEncryptionCertificateFromKeystore();
        if (cert != null) {
            pkiTraceLogger.logExit(true);
        } else {
            pkiTraceLogger.logExit();
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Certificate getEncryptionCertificateFromKeystore() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate cert = ksMgr.getCAKeystore("encryption").getCertificate("encryption");
            if (cert == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_encryption_cert_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return cert;
        }
    }

    public static PrivateKey getSigningPrivateKey() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        KeyExpiryChecker.checkForSigningKeyExpiry();
        PrivateKey key = KeyStoreReader.getSigningPrivateKeyFromKeyStore();
        if (key != null) {
            pkiTraceLogger.logExit(true);
        } else {
            pkiTraceLogger.logExit();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getSigningPrivateKeyFromKeyStore() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            PrivateKey key = ksMgr.getCAKeystore("encryption").getPrivateKey("encryption");
            if (key == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_signing_priv_key_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getSigningCertificate() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate cert = ksMgr.getCAKeystore("encryption").getCertificate("encryption");
            if (cert == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_signing_cert_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return cert;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] getSigningCertificateChain() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate[] certs = ksMgr.getCAKeystore("encryption").getCertificateChain("encryption");
            if (certs == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_sign_cert_chain_not_found", new String[]{"encryption", config.getCAMKeystoreLocation()}));
                pkiTraceLogger.logExit(cce);
                throw cce;
            }
            pkiTraceLogger.logExit(true);
            return certs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getCAPrivateKey() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            KeyExpiryChecker.checkForCAKeyExpiry();
            PrivateKey key = ksMgr.getCAKeystore("encryption").getPrivateKey("ca");
            if (key == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ca_priv_key_not_found", new String[]{"ca", config.getCAMKeystoreLocation()}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            caTraceLogger.logExit(true);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCACertificate() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate cert = ksMgr.getCAKeystore("ca").getCertificate("ca");
            if (cert == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ca_cert_not_found", new String[]{"ca", config.getCAMKeystoreLocation()}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            caTraceLogger.logExit(true);
            return cert;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] getAllCertificates() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        Object object = KeyExpiryChecker.calock;
        synchronized (object) {
            Certificate[] certs = ksMgr.getCAKeystore("ca").getAllCertificates();
            if (certs == null) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_ca_cert_not_found", new String[]{"ca", config.getCAMKeystoreLocation()}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            caTraceLogger.logExit(true);
            return certs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyCertificateChainIsTrusted(X509Certificate[] chain, boolean retryAfterSyncOnTrustFailure) throws CAMCryptoException {
        caTraceLogger.logEnter();
        boolean reverifyingAfterSync = false;
        while (true) {
            CAMCryptoException cce;
            try {
                X509Certificate bcCert;
                ByteArrayInputStream bais;
                CertificateFactory cf = null;
                if (JVMEnvironment.getInstance().isFIPSEnabled()) {
                    String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
                    cf = CertificateFactory.getInstance("X.509", jceProvider);
                } else {
                    cf = CertificateFactory.getInstance("X.509", "BC");
                }
                CertPathValidator validator = CertPathValidator.getInstance("PKIX", "BC");
                HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                ArrayList<X509Certificate> certchain = new ArrayList<X509Certificate>();
                Object object = KeyExpiryChecker.calock;
                synchronized (object) {
                    for (int i = chain.length - 1; i >= 0; --i) {
                        boolean cert_is_selfsigned;
                        X509Certificate cert;
                        int j;
                        Certificate[] path = ksMgr.getCAKeystore("ca").getIssuerCertificateChain(chain[i]);
                        if (path == null || path.length <= 0) continue;
                        for (j = 0; j <= i; ++j) {
                            bais = new ByteArrayInputStream(chain[j].getEncoded());
                            cert = (X509Certificate)cf.generateCertificate(bais);
                            cert_is_selfsigned = cert.getIssuerDN().equals(cert.getSubjectDN());
                            if (cert_is_selfsigned) continue;
                            certchain.add(cert);
                        }
                        for (j = 0; j < path.length; ++j) {
                            bais = new ByteArrayInputStream(path[j].getEncoded());
                            cert = (X509Certificate)cf.generateCertificate(bais);
                            cert_is_selfsigned = cert.getIssuerDN().equals(cert.getSubjectDN());
                            if (cert_is_selfsigned) continue;
                            certchain.add(cert);
                        }
                        bais = new ByteArrayInputStream(path[path.length - 1].getEncoded());
                        bcCert = (X509Certificate)cf.generateCertificate(bais);
                        boolean cert_is_selfsigned2 = bcCert.getIssuerDN().equals(bcCert.getSubjectDN());
                        if (!cert_is_selfsigned2) break;
                        trustAnchors.add(new TrustAnchor(bcCert, null));
                        break;
                    }
                }
                if (trustAnchors.isEmpty()) {
                    byte[] encodedCACert;
                    try {
                        encodedCACert = KeyStoreReader.getCACertificate().getEncoded();
                    }
                    catch (Exception e) {
                        encodedCACert = null;
                    }
                    if (encodedCACert != null) {
                        bais = new ByteArrayInputStream(encodedCACert);
                        bcCert = (X509Certificate)cf.generateCertificate(bais);
                        trustAnchors.add(new TrustAnchor(bcCert.getSubjectDN().getName(), bcCert.getPublicKey(), null));
                    }
                }
                CertPath certPath = cf.generateCertPath(certchain);
                CAMCertSHA2Verifier verifier = new CAMCertSHA2Verifier();
                verifier.verifyCerts(trustAnchors);
                verifier.verifyCerts(certPath);
                PKIXParameters params = new PKIXParameters(trustAnchors);
                params.setRevocationEnabled(false);
                validator.validate(certPath, params);
            }
            catch (CertPathValidatorException cpve) {
                if (retryAfterSyncOnTrustFailure && !reverifyingAfterSync) {
                    Configuration config = Configuration.getInstance();
                    if (!config.getUsingThirdPartyCA()) {
                        try {
                            CaFreshnessHandler cafh = CaFreshnessHandler.getInstance();
                            if (cafh.needSync()) {
                                CaSyncHandler cash = CaSyncHandler.getInstance();
                                cash.synchronizeCaCerts();
                            }
                        }
                        catch (CAMCryptoException cce2) {
                            CAMCryptoException cce1 = new CAMCryptoException(cce2, MessageSet.getMessage("CAM_CRP_cert_trust_error", new String[]{chain[0].getSubjectDN().getName(), chain[0].getIssuerDN().getName()}));
                            caTraceLogger.logExit(cce1);
                            throw cce1;
                        }
                    }
                    reverifyingAfterSync = true;
                    continue;
                }
                cce = new CAMCryptoException(cpve, MessageSet.getMessage("CAM_CRP_cert_trust_error", new String[]{chain[0].getSubjectDN().getName(), chain[0].getIssuerDN().getName()}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            catch (CAMCryptoException cce3) {
                caTraceLogger.logExit(cce3);
                throw cce3;
            }
            catch (Exception e) {
                cce = new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_trust_error", new String[]{chain[0].getSubjectDN().getName(), chain[0].getIssuerDN().getName()}));
                caTraceLogger.logExit(cce);
                throw cce;
            }
            break;
        }
        caTraceLogger.logExit(true);
    }

    public static void verifyCertificateIsTrusted(Certificate cert, boolean retryAfterSyncOnTrustFailure) throws CAMCryptoException {
        caTraceLogger.logEnter();
        X509Certificate x509Cert = (X509Certificate)cert;
        caTraceLogger.addParameter("certificate subject", x509Cert.getSubjectDN().toString());
        try {
            KeyStoreReader.verifyCACertificateIsTrusted(cert, retryAfterSyncOnTrustFailure);
            caTraceLogger.logExit("Verified CA certificate");
        }
        catch (CAMCryptoException cce) {
            if (x509Cert.getIssuerDN().equals(x509Cert.getSubjectDN())) {
                KeyStoreReader.verifySelfSignedClientCertificateIsTrusted(x509Cert);
                caTraceLogger.logExit("Verified Self-signed certificate");
            }
            throw cce;
        }
        caTraceLogger.logExit(true);
    }

    public static void verifyCACertificateIsTrusted(Certificate cert, boolean retryAfterSyncOnTrustFailure) throws CAMCryptoException {
        caTraceLogger.logEnter();
        X509Certificate[] x509chain = null;
        x509chain = KeyStoreReader.getCertificateChain(cert);
        if (x509chain == null) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cert_trust_error", new String[]{((X509Certificate)cert).getSubjectDN().getName(), ((X509Certificate)cert).getIssuerDN().getName()}));
            caTraceLogger.logExit("Not able to get certificate chain. Exception: " + cce.toString());
            throw cce;
        }
        if (x509chain.length == 1) {
            CAMKeyStore caKeystore = ksMgr.getCAKeystore("ca");
            if (!KeyStoreReader.isCertInKeystore(cert, caKeystore) || !new CAMCertSHA2Verifier().isSupportedSignatureAlg((X509Certificate)cert)) {
                CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_cert_trust_error", new String[]{((X509Certificate)cert).getSubjectDN().getName(), ((X509Certificate)cert).getIssuerDN().getName()}));
                caTraceLogger.logExit("Certificate is not trusted as CA certificate. Exception: " + cce.toString() + " " + ((X509Certificate)cert).getSigAlgName());
                throw cce;
            }
        } else {
            KeyStoreReader.verifyCertificateChainIsTrusted(x509chain, retryAfterSyncOnTrustFailure);
        }
        caTraceLogger.logExit(true);
    }

    public static void verifySelfSignedClientCertificateIsTrusted(X509Certificate cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        CAMKeyStore clientTrustStore = ksMgr.getClientTruststore();
        if (!KeyStoreReader.isCertInKeystore(cert, clientTrustStore) || !new CAMCertSHA2Verifier().isSupportedSignatureAlg(cert)) {
            CAMCryptoException cce = new CAMCryptoException(MessageSet.getMessage("CAM_CRP_self_cert_error", new String[]{cert.getSubjectDN().getName()}));
            caTraceLogger.logExit("Self signed certificate is not trusted as CA certificate. Exception: " + cce.toString() + " " + cert.getSigAlgName());
            throw cce;
        }
        caTraceLogger.logExit(true);
    }

    private static boolean isCertInKeystore(Certificate cert, CAMKeyStore camKeyStore) throws CAMCryptoException {
        boolean ret = false;
        Certificate[] certs = camKeyStore.getAllCertificates();
        if (certs != null) {
            PublicKey certPublicKey = cert.getPublicKey();
            for (int i = 0; i < certs.length; ++i) {
                if (!certs[i].getPublicKey().equals(certPublicKey)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static X509Certificate[] getCertificateChain(Certificate cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        if (cert == null) {
            caTraceLogger.logExit("Null certificate");
            return null;
        }
        Certificate[] certchain = ksMgr.getCAKeystore("ca").getIssuerCertificateChain(cert);
        X509Certificate[] x509chain = null;
        if (certchain != null) {
            x509chain = new X509Certificate[certchain.length + 1];
            x509chain[0] = (X509Certificate)cert;
            System.arraycopy(certchain, 0, x509chain, 1, certchain.length);
        } else {
            x509chain = new X509Certificate[]{(X509Certificate)cert};
        }
        caTraceLogger.logExit(true);
        return x509chain;
    }

    public static X509Certificate getIssuerCA(Certificate cert) throws CAMCryptoException {
        caTraceLogger.logEnter();
        X509Certificate issuerCA = null;
        X509Certificate[] certChain = KeyStoreReader.getCertificateChain(cert);
        for (int i = 0; i < certChain.length; ++i) {
            if (certChain[i].getBasicConstraints() <= -1) continue;
            issuerCA = certChain[i];
            break;
        }
        caTraceLogger.logExit(true);
        return issuerCA;
    }

    protected static List<? extends Object> getCSKEntryVer30(String pwd, String base64line) throws CAMCryptoException {
        SecretKey desEdeKey;
        IvParameterSpec ivParam;
        byte[] lineBytes = KeyStoreReader.decodeBase64Line(base64line);
        int lineLength = lineBytes.length;
        ByteArrayInputStream bios = new ByteArrayInputStream(lineBytes);
        int saltLength = 24;
        int encCskLength = lineLength - saltLength;
        byte[] salt = new byte[saltLength];
        byte[] encCsk = new byte[encCskLength];
        bios.read(salt, 0, saltLength);
        bios.read(encCsk, 0, encCskLength);
        try {
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
            generator.init(pwd.getBytes(), salt, 100);
            ParametersWithIV cpiv = (ParametersWithIV)generator.generateDerivedParameters(192, 64);
            byte[] iv = cpiv.getIV();
            ivParam = new IvParameterSpec(iv);
            KeyParameter key = (KeyParameter)cpiv.getParameters();
            byte[] keyMaster = key.getKey();
            DESedeKeySpec ks = new DESedeKeySpec(keyMaster);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("TripleDES", "IBMJCE");
            desEdeKey = skf.generateSecret(ks);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_create_keystore_encryption_key", new String[]{base64line}));
        }
        EncodedCSK encodedCsk = null;
        try {
            byte[] out = new byte[encCsk.length + 8];
            Cipher decryptCipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            decryptCipher.init(2, (Key)desEdeKey, ivParam);
            int outLen = decryptCipher.doFinal(encCsk, 0, encCsk.length, out, 0);
            byte[] cskBytes = new byte[outLen];
            System.arraycopy(out, 0, cskBytes, 0, outLen);
            encodedCsk = new EncodedCSK(cskBytes);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_decrypt_encoded_csk_content", new String[]{base64line}));
        }
        SecretKey csk = encodedCsk.getKey();
        Date date = encodedCsk.getCreationDate();
        return Arrays.asList(csk, date);
    }

    protected static List<? extends Object> getCSKEntryVer40(String pwd, String base64line) throws CAMCryptoException {
        byte[] lineBytes = KeyStoreReader.decodeBase64Line(base64line);
        int lineLength = lineBytes.length;
        ByteArrayInputStream bios = new ByteArrayInputStream(lineBytes);
        int saltLength = 24;
        int encCskLength = lineLength - saltLength;
        byte[] salt = new byte[saltLength];
        byte[] encCsk = new byte[encCskLength];
        bios.read(salt, 0, saltLength);
        bios.read(encCsk, 0, encCskLength);
        String jceProvider = JVMEnvironment.getInstance().getJCEProvider();
        SecretKey aesKey = CAMCSKKeyStore.getSecertKeyfromString(pwd, "AES", jceProvider);
        EncodedCSK encodedCsk = null;
        try {
            byte[] out = new byte[encCsk.length + 16];
            Cipher decryptCipher = Cipher.getInstance("AES", jceProvider);
            decryptCipher.init(2, aesKey);
            int outLen = decryptCipher.doFinal(encCsk, 0, encCsk.length, out, 0);
            byte[] cskBytes = new byte[outLen];
            System.arraycopy(out, 0, cskBytes, 0, outLen);
            encodedCsk = new EncodedCSK(cskBytes);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_could_not_decrypt_encoded_csk_content", new String[]{base64line}));
        }
        SecretKey csk = encodedCsk.getKey();
        Date date = encodedCsk.getCreationDate();
        return Arrays.asList(csk, date);
    }

    protected static byte[] decodeBase64Line(String base64line) throws CAMCryptoException {
        byte[] lineBytes = null;
        try {
            lineBytes = CryptoWrapper.decodeBase64(base64line.getBytes());
        }
        catch (Exception e) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_read_keystore_content_error", new String[]{base64line}));
        }
        if (lineBytes == null) {
            throw new CAMCryptoException(MessageSet.getMessage("CAM_CRP_read_keystore_content_error", new String[]{base64line}));
        }
        return lineBytes;
    }
}

