/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.external.flipper;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.config.external.FixedDelayPollingSchedulerOnYourExecutor;
import com.ibm.bi.config.external.flipper.FlipperREST;
import com.ibm.bi.config.external.flipper.FlipperRestInterface;
import com.ibm.bi.config.util.ConfigurationUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlipperRESTFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FlipperRESTFactory.class);
    private boolean clientIsReady = false;
    private ScheduledExecutorService readyCheckScheduledExecSvc;
    private ScheduledFuture<?> scheduledReadyCheck;
    private CountDownLatch latch = new CountDownLatch(1);
    protected int WAIT_TIMEOUT = 20;
    private static FlipperRESTFactory instance = new FlipperRESTFactory();
    public FlipperRestInterface flipperRest;

    FlipperRESTFactory() {
    }

    protected void checkTimeout() {
        int timeout = Integer.getInteger("CONFIG_WAIT_TIMEOUT_MINUTE", 20);
        if (timeout > 0) {
            this.WAIT_TIMEOUT = timeout;
        }
        LOG.debug("checkTimeout - timeout = {}", (Object)this.WAIT_TIMEOUT);
    }

    public void setIsReady(boolean isready) {
        this.clientIsReady = isready;
    }

    public boolean isReady() {
        return this.clientIsReady;
    }

    public static FlipperRESTFactory getInstance() {
        return instance;
    }

    public synchronized void startup() {
        this.checkTimeout();
        this.initialize();
    }

    public synchronized FlipperRestInterface getFlipperRest() {
        if (!this.clientIsReady) {
            LOG.debug("getFlipperRest() - flipper service is not ready yet, wait until it's ready.");
            try {
                boolean isready = this.latch.await(this.WAIT_TIMEOUT, TimeUnit.MINUTES);
                if (!isready) {
                    LOG.error("getFlipperRest - exceed time limit {} minutes and flipper service is still not ready, return.", (Object)this.WAIT_TIMEOUT);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.flipperRest;
    }

    protected int getFlipperSSLPort() {
        if (ConfigurationUtils.runningOnCloud()) {
            return ConfigurationUtils.getFlipperPort();
        }
        try {
            ConfigurationPropertyFactory configPropInst = ConfigurationPropertyFactory.getInstance();
            int mutAuthSSLPort = configPropInst.getIntProperty("CFS.configGroupMemberSyncPort", -1).get();
            return mutAuthSSLPort;
        }
        catch (Exception e) {
            LOG.error("Unable to get flipper ssl port. ", (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        FlipperRESTFactory flipperRESTFactory = this;
        synchronized (flipperRESTFactory) {
            this.flipperRest = this.createFlipperRest();
            if (this.isFlipperServiceReady()) {
                this.clientIsReady = true;
            } else {
                LOG.info("initialize: flipper service is NOT ready yet, start readyChecker.");
                this.startReadyChecker();
            }
        }
    }

    protected void startReadyChecker() {
        this.readyCheckScheduledExecSvc = FixedDelayPollingSchedulerOnYourExecutor.makePollingExecutorService((String)"com.ibm.bi.config.flipperrest.readyChecker");
        this.scheduledReadyCheck = this.readyCheckScheduledExecSvc.scheduleAtFixedRate(this::checkReady, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    protected FlipperRestInterface createFlipperRest() {
        return new FlipperREST(ConfigurationUtils.getFlipperhost(), this.getFlipperSSLPort());
    }

    protected boolean isFlipperServiceReady() {
        return this.flipperRest.testReady();
    }

    protected void makeReady() {
        this.clientIsReady = true;
        if (this.scheduledReadyCheck != null) {
            this.scheduledReadyCheck.cancel(false);
            this.scheduledReadyCheck = null;
        }
        if (this.readyCheckScheduledExecSvc != null) {
            this.readyCheckScheduledExecSvc.shutdown();
            this.readyCheckScheduledExecSvc = null;
        }
        LOG.info("makeReady: clientIsReady is {}.", (Object)this.clientIsReady);
        this.latch.countDown();
    }

    public void checkReady() {
        try {
            if (this.isFlipperServiceReady()) {
                this.makeReady();
            }
        }
        catch (Exception x) {
            LOG.error("ReadyChecker - exception when checking if flipper service is ready", (Throwable)x);
        }
    }
}

