/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.content.apps.resources.BaseResource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.EntityTag;
import org.apache.commons.lang.StringUtils;

public class BaseModuleEtag {
    private static final String INVALID_CACHE_VALIDATOR = "NOT_SUPPORTED";
    private String objectId;
    private String cacheValidator;

    public BaseModuleEtag(HttpServletRequest servletRequest) {
        String[] parts;
        String etag = this.getRequestEtag(servletRequest);
        if (etag != null && (parts = StringUtils.split((String)etag, (char)'|')).length == 2) {
            this.cacheValidator = parts[0];
            this.objectId = parts[1];
        }
    }

    private String getRequestEtag(HttpServletRequest servletRequest) {
        String s = servletRequest.getHeader("If-None-Match");
        if (s != null) {
            if (s.length() > 2 && s.charAt(0) == '\"') {
                s = s.substring(1, s.length() - 1);
            }
            if (BaseResource.isSupportedEtag(s)) {
                return s;
            }
        }
        return null;
    }

    public void setObjectId(String id) {
        this.objectId = id;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getCacheValidator() {
        return this.cacheValidator;
    }

    public void setCacheValidator(String validator) {
        this.cacheValidator = INVALID_CACHE_VALIDATOR.equals(validator) ? null : validator;
    }

    public EntityTag toETag() {
        if (this.cacheValidator != null && this.objectId != null) {
            return new EntityTag(this.cacheValidator + "|" + this.objectId);
        }
        return null;
    }
}

