/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.apps.resources.BaseModuleEtag;
import com.ibm.bi.content.apps.resources.BaseResource;
import com.ibm.bi.content.apps.utils.CmRest;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.BiBus;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.ArrayUtils;

public class BaseModuleObject
extends BaseResource {
    public static final String BASEMODULE = "baseModule";
    public static final String MODULE = "module";
    public static final String SOCIAL_MEDIA_PROJECT = "socialMediaProject";
    public static final String REPORTVERSION = "reportVersion";
    public static final String SMARTSMODULE = "smartsModule";
    private static final String DEFAULT_BASEMODULE_PROPS = "physicalDefinition,physicalAnalytics,baseDefinition,baseAnalytics";
    private static final String DEFAULT_SMARTMODULE_PROPS = "smartsData";
    protected BaseModuleEtag etag = null;
    private String matchedId = null;
    private String matchedType = null;

    protected String createReportVersionObject(String storeID) throws Exception {
        JsonObject reportVersionProperties = new JsonObject();
        List<?> results = this.addObject(storeID, REPORTVERSION, reportVersionProperties);
        return this.getObjectIdPropertyFromResults(results);
    }

    protected String getObjectStoreID(String path) throws Exception {
        JsonObject obj = this.querySingleObject(path, (List)new JsonArray(new Object[]{"id"}), null);
        return obj == null ? null : obj.getString("id");
    }

    protected JsonArray getProperties(String defaults) {
        return new FieldsQueryParam(this.servletRequest.getParameter("fields"), defaults).getProperties();
    }

    protected boolean isBaseModuleStoredUnderReportVersion(String storeID) throws Exception {
        String objectType = this.getObjectType(storeID);
        return "dataSet2".equals(objectType) || "uploadedFile".equals(objectType);
    }

    protected RestException invalidParentException(String storeID) throws Exception {
        return this.invalidObjectIdException(storeID, "Path parameter ID does not represent a valid parent.");
    }

    @Override
    protected String getObjectType(String storeID) throws Exception {
        if (!storeID.equals(this.matchedId)) {
            this.matchedId = storeID;
            this.matchedType = super.getObjectType(storeID);
            if (this.matchedType == null) {
                throw this.invalidParentException(storeID);
            }
        }
        return this.matchedType;
    }

    protected String getObjectIdPropertyFromResults(List<?> results) throws Exception {
        JsonArray objects = (JsonArray)results;
        if (objects == null || objects.size() != 1) {
            return null;
        }
        JsonObject object = objects.getObject(0);
        if (object != null) {
            return object.getString("id");
        }
        return null;
    }

    protected Response getBaseModule(String storeID) throws Exception {
        this.etag = new BaseModuleEtag(this.servletRequest);
        Response result = this.checkPreconditions(false);
        if (result != null) {
            return result;
        }
        String bmID = this.etag.getObjectId();
        if (bmID == null) {
            bmID = this.getBaseModuleID(storeID);
            this.etag.setObjectId(bmID);
        }
        return this.queryObject(PathBuilder.fromId(bmID), this.getProperties(DEFAULT_BASEMODULE_PROPS));
    }

    protected Response getSmartsModules(String storeID) throws Exception {
        this.etag = new BaseModuleEtag(this.servletRequest);
        Response result = this.checkPreconditions(true);
        if (result != null) {
            return result;
        }
        String parentId = this.etag.getObjectId();
        if (parentId == null) {
            parentId = this.getSmartsParentId(storeID);
            this.etag.setObjectId(parentId);
        }
        PathBuilder path = new PathBuilder().id(parentId).children(SMARTSMODULE);
        this.addTagsToPath(path);
        return this.queryObject(path.toString(), this.getProperties(DEFAULT_SMARTMODULE_PROPS));
    }

    protected String getSmartsParentId(String storeID) throws Exception {
        String objectType = this.getObjectType(storeID);
        if (MODULE.equals(objectType)) {
            return storeID;
        }
        if (SOCIAL_MEDIA_PROJECT.equals(objectType)) {
            return this.getModuleID(storeID);
        }
        return this.getBaseModuleID(storeID);
    }

    protected void addTagsToPath(PathBuilder path) throws Exception {
        Object[] tags = this.getArrayQueryParam("tags");
        if (ArrayUtils.isNotEmpty((Object[])tags)) {
            path.oneOf("@tags", (String[])tags);
        }
    }

    protected Response checkPreconditions(boolean forSmarts) throws Exception {
        if (this.etag.getCacheValidator() != null) {
            int status = this.doCheckPreconditions(forSmarts);
            if (status == 304) {
                return Response.notModified().build();
            }
            this.etag.setCacheValidator(null);
            if (status != 205) {
                this.etag.setObjectId(null);
            }
        }
        return null;
    }

    protected Response queryObject(String path, JsonArray props) throws Exception {
        JsonObject object = (JsonObject)this.queryMultipleCache(path, props, null);
        return this.wrapResult((Map)object).build();
    }

    private String getModuleID(String storeID) throws Exception {
        String id = this.getObjectStoreID(this.getModulePath(storeID));
        if (id == null) {
            throw this.invalidParentException(storeID);
        }
        return id;
    }

    private String getModulePath(String storeID) {
        return new PathBuilder().id(storeID).children(MODULE).toString();
    }

    protected String getBaseModuleID(String storeID) throws Exception {
        String id = this.getObjectStoreID(this.getBaseModulePath(storeID));
        if (id == null) {
            throw this.invalidParentException(storeID);
        }
        return id;
    }

    private String getBaseModulePath(String storeID) throws Exception {
        String parentId = storeID;
        if (this.isBaseModuleStoredUnderReportVersion(storeID) && (parentId = this.getReportVersionStoreID(storeID)) == null) {
            throw this.invalidParentException(storeID);
        }
        return new PathBuilder().id(parentId).children(BASEMODULE).last().toString();
    }

    private String getReportVersionStoreID(String storeID) throws Exception {
        String path = new PathBuilder().id(storeID).children(REPORTVERSION).last().toString();
        return this.getObjectStoreID(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doCheckPreconditions(boolean forSmarts) throws Exception {
        PathBuilder path = new PathBuilder().id(this.etag.getObjectId());
        if (forSmarts) {
            path.children(SMARTSMODULE);
        }
        try (CmRest cmRest = new CmRest(this.servletRequest);){
            int n = cmRest.validateEtag(path.toString(), this.etag.getCacheValidator());
            return n;
        }
        catch (ContentException ce) {
            logger.warn("Error calling CM REST API, will not use fast Etag validation", (Throwable)ce);
            return 0;
        }
    }

    protected Response deleteObjects(String path) throws Exception {
        JsonArray objects = new JsonArray(new Object[]{path});
        BiBus bus = this.getNewBiBus();
        Long count = (Long)bus.contentManager.delete((List)objects, (Map)this.buildDeleteOptions());
        return this.wrapCount(count);
    }

    @Override
    protected EntityTag getEtagFromCacheValidator(Map data) {
        this.etag.setCacheValidator(((JsonObject)data).getString("cacheValidator"));
        return this.etag.toETag();
    }

    @Override
    protected String getRequestEtag() {
        return "";
    }
}

