/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.content.apps.resources.filters.TrustVerificationFilter;
import com.ibm.bi.content.apps.soap_handlers.EncryptingPropHandler;
import com.ibm.bi.content.apps.utils.CmRest;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.content.apps.utils.TrustedContext;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.schema.EnumType;
import com.ibm.bi.soap.schema.PropertyHandler;
import com.ibm.bi.soap.schema.Schema;
import com.ibm.bi.soap.schema.StructType;
import com.ibm.bi.soap.schema.Type;
import com.ibm.bi.soap.schema.TypeLibrary;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapTransportFactory;
import com.netflix.config.DynamicBooleanProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource {
    public static final String PUBLIC_ETAG = "41-";
    public static final String PRIVATE_ETAG = "42-";
    private static final String INVALID_CACHE_VALIDATOR = "NOT_SUPPORTED";
    private static String CHARSET = "UTF-8";
    protected static final String ATTR_IGNOREINVALIDOBJREF = "ignoreInvalidObjectReference";
    protected static final Logger logger = LoggerFactory.getLogger(BaseResource.class);
    private static final HashSet<String> NON_CACHEABLE_PROPS = new HashSet<String>(Arrays.asList("defaultOutputFormat"));
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpServletRequest servletRequest;
    @Context
    protected HttpServletResponse servletResponse;
    @Context
    protected Request request;
    @HeaderParam(value="X-BI-Forwarded-For")
    private String restClientForwarded;
    private SoapContext soapContext;
    private BiBus biBus = null;
    private BiBus trustedBiBus = null;

    static void setPropHandler(Schema bus, String type, String propName, PropertyHandler handler) {
        ((StructType)bus.getType(type)).getProperty(propName).setHandler(handler);
    }

    protected BiBus getNewBiBus() throws Exception {
        if (this.biBus == null) {
            this.soapContext = this.makeSoapContext(this.servletRequest);
            this.biBus = new BiBus(SoapTransportFactory.getInstance().create(), this.soapContext, this.buildBaseURL());
        }
        return this.biBus;
    }

    protected BiBus getTrustedBiBus(String serviceID) throws Exception {
        if (this.trustedBiBus == null) {
            TrustedContext soapContext = new TrustedContext(this.servletRequest, serviceID);
            this.trustedBiBus = new BiBus(SoapTransportFactory.getInstance().create(), (SoapContext)soapContext, this.buildBaseURL());
        }
        return this.trustedBiBus;
    }

    private SoapContext makeSoapContext(HttpServletRequest request) {
        String serviceID = TrustVerificationFilter.isFromTrustedService(request);
        if (serviceID != null) {
            return new TrustedContext(this.servletRequest, serviceID);
        }
        return new SoapContext(this.servletRequest);
    }

    protected Type getBiBusType(String name) {
        return BiBus.getTypeLibrary().getSchemaByName("bus").getType(name);
    }

    protected String buildBaseURL() {
        String original = (String)this.servletRequest.getAttribute("X-Original-URI");
        if (original != null) {
            return original;
        }
        logger.trace("X-Original-URI missing for url: %s", (Object)this.servletRequest.getRequestURL().toString());
        StringBuilder buf = new StringBuilder();
        buf.append(this.servletRequest.getContextPath());
        buf.append(this.servletRequest.getServletPath());
        return buf.toString();
    }

    protected JsonObject buildQueryOptions(FieldsQueryParam fields, boolean schemaInfo) {
        if (fields.getRefProps() == null && !schemaInfo) {
            return null;
        }
        JsonObject result = new JsonObject();
        if (fields.getRefProps() != null) {
            result.put("refProps", (Object)fields.getRefProps());
        }
        if (schemaInfo) {
            result.put("schemaInfo", (Object)schemaInfo);
        }
        return result;
    }

    protected Response wrapPostResult(List data) {
        JsonObject newObj = (JsonObject)data.get(0);
        String uri = "";
        try {
            uri = (String)newObj.getObject("_meta").getObject("links").getObject("self").get("url");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.soapContext.saveState(Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)this.buildLocationURI(uri))).build();
    }

    protected String buildLocationURI(String uri) {
        if (this.isFromRESTClient() && StringUtils.contains((String)uri, (String)"/bi/")) {
            return uri.substring(uri.indexOf("/bi/"));
        }
        return uri;
    }

    boolean isFromRESTClient() {
        return StringUtils.isNotEmpty((String)this.restClientForwarded);
    }

    protected Response.ResponseBuilder wrapResult(Map data) {
        EntityTag etag = this.getEtagFromCacheValidator(data);
        JsonObject result = new JsonObject();
        result.put("data", (Object)this.extractQueryMultipleCacheResults(data));
        Response.ResponseBuilder builder = this.buildResponse(result, this.isResultPrivate(etag));
        if (etag != null) {
            builder = builder.tag(etag);
        }
        return builder;
    }

    boolean isResultPrivate(EntityTag etag) {
        return etag == null || !etag.getValue().startsWith(PUBLIC_ETAG);
    }

    protected Response.ResponseBuilder buildResponse(Object data, boolean isPrivate) {
        Response.ResponseBuilder builder = Response.ok((Object)data);
        return this.soapContext.saveState(builder.cacheControl(this.createCC(isPrivate)));
    }

    protected JsonArray extractQueryMultipleCacheResults(Map data) {
        JsonArray items = new JsonArray();
        JsonArray replies = ((JsonObject)data).getArray("replies");
        if (replies != null) {
            for (Object reply : replies) {
                items.addAll((Collection)((JsonObject)reply).getArray("queryResult"));
            }
        }
        return items;
    }

    protected Response.ResponseBuilder wrapResult(List data) {
        JsonObject result = new JsonObject();
        result.put("data", (Object)data);
        return this.buildResponse(result, true);
    }

    protected CacheControl createCC(boolean isPrivate) {
        CacheControl cc = new CacheControl();
        cc.setPrivate(isPrivate);
        cc.setMustRevalidate(true);
        cc.setNoTransform(false);
        return cc;
    }

    protected EntityTag getEtagFromCacheValidator(Map data) {
        String cacheValidator = (String)data.get("cacheValidator");
        if (cacheValidator != null && !INVALID_CACHE_VALIDATOR.equals(cacheValidator)) {
            return new EntityTag(cacheValidator);
        }
        return null;
    }

    protected Response wrapCount(Long count) {
        JsonObject result = new JsonObject();
        result.put("count", (Object)count);
        return this.soapContext.saveState(Response.ok((Object)result)).build();
    }

    protected Response noContent() {
        return this.soapContext.saveState(Response.noContent()).build();
    }

    protected JsonObject buildDeleteOptions() throws Exception {
        JsonObject options = new JsonObject();
        this.setRecursiveOption(options);
        this.setForceOption(options);
        return options.isEmpty() ? null : options;
    }

    private void setForceOption(JsonObject options) throws Exception {
        this.setBooleanOption(options, "force");
    }

    protected JsonObject buildAddOptions() throws Exception {
        JsonObject options = new JsonObject();
        this.setBooleanOption(options, ATTR_IGNOREINVALIDOBJREF);
        this.setUpdateAction(options, false);
        return options.isEmpty() ? null : options;
    }

    protected JsonObject buildCopyOptions() throws Exception {
        JsonObject options = new JsonObject();
        this.setRecursiveOption(options);
        this.setUpdateAction(options, true);
        return options.isEmpty() ? null : options;
    }

    private void setRecursiveOption(JsonObject options) throws Exception {
        this.setBooleanOption(options, "recursive");
    }

    protected JsonObject buildMoveOptions() throws Exception {
        JsonObject options = new JsonObject();
        this.setUpdateAction(options, true);
        return options.isEmpty() ? null : options;
    }

    protected JsonObject buildUpdateOptions() throws Exception {
        JsonObject options = new JsonObject();
        this.setBooleanOption(options, "updateTenantIDRecursive");
        this.setBooleanOption(options, ATTR_IGNOREINVALIDOBJREF);
        this.setUpdateAction(options, false);
        return options.isEmpty() ? null : options;
    }

    private void setUpdateAction(JsonObject options, boolean updateOnOverwrite) throws Exception {
        String updateAction = this.getStringQueryParam("updateAction");
        if (updateAction != null) {
            DynamicBooleanProperty doUpdate;
            this.validateUpdateAction(updateAction);
            if (updateOnOverwrite && "replace".equals(updateAction) && (doUpdate = ConfigurationPropertyFactory.getInstance().getBooleanProperty("Portal.updateTargetObjectWhenOverwrite", false)).get()) {
                updateAction = "update";
            }
            options.put("updateAction", (Object)updateAction);
        }
    }

    private void validateUpdateAction(String updateAction) {
        if (!((EnumType)this.getBiBusType("updateActionEnum")).contains(updateAction)) {
            throw new RestException(400, new ContentMessage(MessageKeys.INVALID_FIELD), (Throwable)new ContentException("Only " + this.getEnumValuesAsString("updateActionEnum") + " are supported for updateAction."));
        }
    }

    protected String getEnumValuesAsString(String type) {
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (Object s : ((EnumType)this.getBiBusType(type)).items().toArray()) {
            buf.append(separator).append((String)s);
            separator = ", ";
        }
        return buf.toString();
    }

    protected Response getSingleCMObject(String searchPath, String defaultProps) throws Exception {
        Response result = this.checkPreconditions(searchPath);
        if (result != null) {
            return result;
        }
        FieldsQueryParam fields = new FieldsQueryParam(this.servletRequest.getParameter("fields"), defaultProps);
        JsonObject options = this.buildQueryOptions(fields, this.getBooleanQueryParam("schemaInfo"));
        boolean cacheable = this.arePropertiesCacheable(fields);
        if (cacheable) {
            Map data = this.queryMultipleCache(searchPath, fields.getProperties(), options);
            return this.wrapResult(data).build();
        }
        BiBus bus = this.getNewBiBus();
        List data = bus.contentManager.query(searchPath, (List)fields.getProperties(), null, (Map)options);
        return this.wrapResult(data).build();
    }

    protected boolean arePropertiesCacheable(FieldsQueryParam fields) {
        for (Object prop : fields.getProperties()) {
            if (!NON_CACHEABLE_PROPS.contains(prop)) continue;
            return false;
        }
        return true;
    }

    protected Response getCMObjects(String searchPath) throws Exception {
        return this.getCMObjects(searchPath, true, null);
    }

    protected Response getCMObjects(String searchPath, boolean cacheable, String props) throws Exception {
        Response result;
        if (cacheable && (result = this.checkPreconditions(searchPath)) != null) {
            return result;
        }
        FieldsQueryParam fields = new FieldsQueryParam(this.servletRequest.getParameter("fields"), props);
        JsonObject options = this.buildQueryOptions(fields, false);
        if (cacheable) {
            Map data = this.queryMultipleCache(searchPath, fields.getProperties(), options);
            return this.wrapResult(data).build();
        }
        BiBus bus = this.getNewBiBus();
        List data = bus.contentManager.query(searchPath, (List)fields.getProperties(), null, (Map)options);
        return this.wrapResult(data).build();
    }

    protected Map queryMultipleCache(String path, JsonArray props, JsonObject options) throws Exception {
        BiBus bus = this.getNewBiBus();
        Map queryRequest = bus.contentManager.queryRequest(path, (List)props, null, (Map)options);
        JsonArray queries = new JsonArray();
        queries.add((Object)queryRequest);
        return bus.contentManager.queryMultipleCache((List)queries, this.getRequestEtag());
    }

    protected String getRequestEtag() {
        String s = this.servletRequest.getHeader("If-None-Match");
        if (s == null) {
            return "";
        }
        if (s.length() > 2 && s.charAt(0) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected Response checkPreconditions(String path) throws Exception {
        int status;
        String ifNoneMatch = this.getRequestEtag();
        if (!BaseResource.isSupportedEtag(ifNoneMatch)) {
            return null;
        }
        try (CmRest cmRest = new CmRest(this.servletRequest);){
            status = cmRest.validateEtag(path, ifNoneMatch);
        }
        catch (ContentException ce) {
            logger.warn("Error calling CM REST API, will not use fast Etag validation", (Throwable)ce);
            return null;
        }
        if (status == 410) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
        if (status != 304) {
            return null;
        }
        return Response.notModified().build();
    }

    public static boolean isSupportedEtag(String etag) {
        return etag.startsWith(PUBLIC_ETAG) || etag.startsWith(PRIVATE_ETAG);
    }

    protected void setBooleanOption(JsonObject options, String optionName) throws Exception {
        if (this.getBooleanQueryParam(optionName)) {
            options.put(optionName, (Object)true);
        }
    }

    protected boolean getBooleanQueryParam(String name) throws Exception {
        return Boolean.parseBoolean(this.getQueryParam(name));
    }

    protected String getStringQueryParam(String name) throws Exception {
        return this.getQueryParam(name);
    }

    protected String getQueryParam(String name) throws Exception {
        String nameValues;
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        if (queryParams != null && !queryParams.isEmpty() && (nameValues = (String)queryParams.getFirst((Object)name)) != null) {
            return BaseResource.decode(nameValues);
        }
        return null;
    }

    private static String decode(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, CHARSET);
    }

    protected String[] getArrayQueryParam(String name) throws Exception {
        String s = this.getQueryParam(name);
        if (s != null) {
            return s.split(",");
        }
        return null;
    }

    protected String getObjectType(String storeID) throws Exception {
        ArrayList props;
        String path = PathBuilder.fromId(storeID);
        JsonObject object = this.querySingleObject(path, props = new ArrayList(), null);
        if (object != null) {
            return object.getString("type");
        }
        return null;
    }

    protected JsonObject querySingleObject(String searchPath, List props, JsonObject options) throws Exception {
        BiBus bus = this.getNewBiBus();
        JsonArray objects = (JsonArray)bus.contentManager.query(searchPath, props, null, (Map)options);
        if (objects == null || objects.size() != 1) {
            return null;
        }
        return objects.getObject(0);
    }

    protected RestException invalidObjectIdException(String storeID, String message) throws Exception {
        return new RestException(404, new ContentMessage(MessageKeys.INVALID_OBJECT_ID, storeID), (Throwable)new ContentException(message));
    }

    protected List<?> addObject(String parentId, String type, JsonObject data) throws Exception {
        BiBus biBus = this.getNewBiBus();
        this.verifyType(data, type);
        JsonArray anArray = new JsonArray();
        anArray.add((Object)data);
        return biBus.contentManager.add(PathBuilder.fromId(parentId), (List)anArray, (Map)this.buildAddOptions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyType(JsonObject data, String type) {
        String dataType = data.getString("type");
        if (dataType == null) {
            if (type == null) throw new RestException(400, new ContentMessage(MessageKeys.MISSING_FIELD, "type"));
            data.put("type", (Object)type);
            return;
        } else {
            if (type == null || type.equals(dataType)) return;
            throw new RestException(400, new ContentMessage(MessageKeys.INVALID_FIELD_VALUE, "type"));
        }
    }

    protected void updateObjectProperties(String storeID, JsonObject data) throws Exception {
        BiBus biBus = this.getNewBiBus();
        String newType = data.getString("type");
        if (newType == null) {
            throw new RestException(400, new ContentMessage(MessageKeys.MISSING_FIELD, "type"));
        }
        JsonArray anArray = new JsonArray();
        data.put("searchPath", (Object)PathBuilder.fromId(storeID));
        anArray.add((Object)data);
        biBus.contentManager.update((List)anArray, (Map)this.buildUpdateOptions());
    }

    static {
        TypeLibrary typeLib = BiBus.getTypeLibrary();
        Schema bus = typeLib.getSchemaByName("bus");
        EncryptingPropHandler handler = new EncryptingPropHandler();
        BaseResource.setPropHandler(bus, "pdfOptionXMLEncodedXML", "value", (PropertyHandler)handler);
    }
}

