/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.shared.BIResource;
import com.netflix.config.DynamicStringProperty;
import com.wordnik.swagger.annotations.Api;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.ListIterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(hidden=true)
@Path(value="/files")
public final class FileManagerResource
extends BIResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileManagerResource.class);
    private static final DynamicStringProperty configuredDirectory = ConfigurationPropertyFactory.getInstance().getStringProperty("DatasetService.directory", System.getProperty("install.dir") + "/data/datasets");
    private HashSet<String> dirNames;
    private int count = 0;

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response delete(JsonObject ids) throws IOException {
        JsonArray idList = (JsonArray)ids.get("objectIds");
        if (idList != null) {
            if (this.isInternalRequest()) {
                this.deleteFiles(idList);
                JsonObject resp = new JsonObject();
                resp.put("deleted", (Object)this.count);
                return Response.ok((Object)resp).build();
            }
            LOGGER.info("External attempt to remove files. {}", (Object)idList.toString());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    private void deleteFiles(JsonArray idList) throws IOException {
        File datasetRoot = new File(this.getDatasetDirectoryPath());
        if (datasetRoot.isDirectory()) {
            this.dirNames = new HashSet();
            ListIterator iterator = idList.listIterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof String)) continue;
                this.dirNames.add((String)next);
            }
            Files.walkFileTree(datasetRoot.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){
                private boolean deleteMe = false;

                @Override
                public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                    String name = dir.getFileName().toString();
                    if (name != null && this.matches(name)) {
                        this.deleteMe = true;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    if (this.deleteMe) {
                        try {
                            FileUtils.forceDelete((File)file.toFile());
                            FileManagerResource.this.count++;
                        }
                        catch (IOException e) {
                            LOGGER.error("Couldn't delete file: {}", (Object)file.toString());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                    if (this.deleteMe) {
                        try {
                            FileUtils.forceDelete((File)dir.toFile());
                            this.deleteMe = false;
                            FileManagerResource.this.count++;
                        }
                        catch (IOException e) {
                            LOGGER.error("Couldn't delete directory: {}", (Object)dir.toString());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                private boolean matches(String name) {
                    return name.contains("_") && FileManagerResource.this.dirNames.contains(name.substring(0, name.indexOf("_")));
                }
            });
        }
    }

    private String getDatasetDirectoryPath() {
        return StringUtils.isEmpty((String)configuredDirectory.getValue()) ? (String)configuredDirectory.getDefaultValue() : configuredDirectory.getValue();
    }
}

