/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.apps.resources.BaseModuleEtag;
import com.ibm.bi.content.apps.resources.BaseModuleObject;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;

public class ModuleObject
extends BaseModuleObject {
    private static final String DEFAULT_MODULE_PROPS = "defaultName,definition,analytics";
    public static final String MODULE = "module";

    protected Response getModule(String storeID) throws Exception {
        this.etag = new BaseModuleEtag(this.servletRequest);
        Response result = this.checkPreconditions(false);
        if (result != null) {
            return result;
        }
        String mID = this.etag.getObjectId();
        return this.queryObject(mID == null ? this.getModulePath(storeID) : PathBuilder.fromId(mID), this.getProperties(DEFAULT_MODULE_PROPS));
    }

    private String getModulePath(String storeID) throws Exception {
        String parentId = storeID;
        return new PathBuilder().id(parentId).children(MODULE).toString();
    }

    @Override
    protected EntityTag getEtagFromCacheValidator(Map data) {
        JsonArray objectReplies = ((JsonObject)data).getArray("replies");
        for (Object reply : objectReplies) {
            JsonArray objectResults = ((JsonObject)reply).getArray("queryResult");
            if (objectResults != null && !objectResults.isEmpty()) {
                Iterator iterator = objectResults.iterator();
                if (!iterator.hasNext()) continue;
                Object result = iterator.next();
                this.etag.setObjectId(((JsonObject)result).getString("id"));
                continue;
            }
            throw new RestException(404, new ContentMessage(MessageKeys.INTERNAL_ERROR), (Throwable)new ContentException("No Modules are associated with this parent ID."));
        }
        this.etag.setCacheValidator(((JsonObject)data).getString("cacheValidator"));
        return this.etag.toETag();
    }
}

