/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.content.apps.resources.ModuleObject;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonObject;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/objects/{id:[ix.].+?}/module")
@Api(value="module", description="Operations on module")
public class ModuleResource
extends ModuleObject {
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a module")
    public Response getModuleObject(@PathParam(value="id") String storeID, @QueryParam(value="fields") FieldsQueryParam fields) throws Exception {
        return this.getModule(storeID);
    }

    @PUT
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update properties of a module object, if it doesnt exist.. it creates a new module.")
    public Response updateModule(@ApiParam(value="Object definition.<p>For update, specifies properties to update. Must specify the type of the object that's being updated.") JsonObject data, @PathParam(value="id") String storeID, @QueryParam(value="updateAction") String updateActionForSwagger) throws Exception {
        String parentId = storeID;
        PathBuilder path = new PathBuilder().id(parentId).children("module");
        String moduleId = this.getObjectStoreID(path.toString());
        if (moduleId == null) {
            return this.createModuleObject(parentId, data);
        }
        this.updateObjectProperties(moduleId, data);
        return this.noContent();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Stores a new module")
    public Response addModule(@ApiParam(value="Object definition.") JsonObject data, @PathParam(value="id") String storeID, @QueryParam(value="updateAction") String updateActionForSwagger) throws Exception {
        List<?> items = this.addObject(storeID, "module", data);
        return this.wrapPostResult(items);
    }

    private Response createModuleObject(String parentID, JsonObject data) throws Exception {
        return this.wrapPostResult(this.addObject(parentID, "module", data));
    }
}

