/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.content.apps.resources.BaseResource;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.restful.ContentManager;
import com.ibm.bi.soap.restful.QueryParams;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/my_assets")
@Api(value="my_assets", description="Internal API for listing assets (uploaded files, packages, modules) ")
public class MyAssetsResource
extends BaseResource {
    private static final String[] ASSET_CLASSES = new String[]{"uploadedFile", "package", "module", "dataset2"};
    private ContentManager cm;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a list of assets (uploaded files, packages, modules, etc) for which user has read access")
    public Response listMyAssets(@ApiParam(value="a comma separated list of search contexts. Valid values: 'public' - Team Content, 'private' - My Folders, 'server' - data sources under Cognos namespace") @QueryParam(value="scope") String scopeForSwagger) throws Exception {
        QueryParams qp = new QueryParams(this.servletRequest);
        String[] scope = qp.getStringArray("scope", "personal");
        JsonArray result = new JsonArray();
        block10: for (String s : scope) {
            PathBuilder path = new PathBuilder();
            switch (s) {
                case "private": {
                    path.id(".my_folders").descendants(ASSET_CLASSES).allPermissions("read");
                    result.addAll((Collection)this.findAssets(path));
                    continue block10;
                }
                case "public": {
                    path.id(".public_folders").descendants(ASSET_CLASSES).allPermissions("read");
                    result.addAll((Collection)this.findAssets(path));
                    continue block10;
                }
                case "server": {
                    path.id("xOg__").children("dataSource").children("dataSourceConnection").children("dataSourceSchema").allPermissions("read");
                    result.addAll((Collection)this.findAssets(path));
                }
            }
        }
        Response responce = Response.ok((Object)result).build();
        return responce;
    }

    private JsonArray findAssets(PathBuilder pb) throws Exception {
        JsonObject result = this.getCM().query(pb.toString(), new JsonArray(new Object[]{"id"}), null, false);
        return result.getArray("objects");
    }

    protected ContentManager getCM() throws Exception {
        if (this.cm == null) {
            this.cm = new ContentManager(this.servletRequest, this.getNewBiBus());
        }
        return this.cm;
    }
}

