/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.application.IPFPathOverrideFilter;
import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.apps.resources.BaseResource;
import com.ibm.bi.content.apps.resources.subresources.HistoryResource;
import com.ibm.bi.content.apps.resources.subresources.OutputResource;
import com.ibm.bi.content.apps.resources.subresources.PackageResource;
import com.ibm.bi.content.apps.utils.CmRest;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.BiBus;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/objects")
@Api(value="objects", description="Operations on object IDs")
@IPFPathOverrideFilter
public class ObjectResource
extends BaseResource {
    @GET
    @Path(value="/{id:[ix.].+?}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns properties of specified object")
    public Response getObjectProperties(@PathParam(value="id") String storeID, @QueryParam(value="fields") FieldsQueryParam fieldsForSwagger, @QueryParam(value="schemaInfo") Boolean schemaInfoForSwagger) throws Exception {
        String path = PathBuilder.fromId(storeID);
        return this.getSingleCMObject(path, null);
    }

    @GET
    @Path(value="/{id:[ix.].+?}/items")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns content of specified object")
    public Response getItems(@PathParam(value="id") String storeID, @QueryParam(value="fields") FieldsQueryParam fieldsForSwagger, @QueryParam(value="nav_filter") Boolean navfilterForSwagger, @QueryParam(value="types") String typesForSwagger, @QueryParam(value="tags") String tagForSwagger) throws Exception {
        String[] tags;
        PathBuilder path = new PathBuilder().id(storeID).children("*");
        String[] types = this.getArrayQueryParam("types");
        if (types != null) {
            path.oneOf("@objectClass", types);
        } else {
            path.noneOf("@objectClass", "model", "packageConfiguration", "drillPath", "baseModule");
        }
        if (this.getBooleanQueryParam("nav_filter")) {
            path.navigationFilter();
        }
        if ((tags = this.getArrayQueryParam("tags")) != null) {
            path.oneOf("@tags", tags);
        }
        return this.getCMObjects(path.toString());
    }

    @GET
    @Path(value="/{id:[ix.].+?}/permissions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the user's permissions", response=JsonObject.class)
    public Response getObjectPermissions(@PathParam(value="id") String storeID) throws Exception {
        try (CmRest cmRest = new CmRest(this.servletRequest);){
            int status = cmRest.getObjectProperty(storeID, "permissions");
            if (status == Response.Status.OK.getStatusCode()) {
                Response response = Response.ok((Object)cmRest.getResponseAsJsonArray()).build();
                return response;
            }
            JsonObject error = new JsonObject();
            error.put("error", (Object)cmRest.getResponseAsString());
            Response response = Response.status((int)status).entity((Object)error).build();
            return response;
        }
    }

    @DELETE
    @Path(value="/{id:[ix.].+?}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes an object")
    public Response deleteObject(@PathParam(value="id") String storeID, @QueryParam(value="force") Boolean forceForSwagger, @QueryParam(value="recursive") Boolean recursiveForSwagger) throws Exception {
        BiBus bus = this.getNewBiBus();
        JsonArray objects = new JsonArray(new Object[]{PathBuilder.fromId(storeID)});
        Long count = (Long)bus.contentManager.delete((List)objects, (Map)this.buildDeleteOptions());
        return this.wrapCount(count);
    }

    @DELETE
    @Produces(value={"application/json"})
    @ApiOperation(value="Bulk delete")
    public Response deleteObjects(@QueryParam(value="ids") @ApiParam(value="Comma-separated list of object ids", required=true) String idsForSwagger, @QueryParam(value="force") Boolean forceForSwagger, @QueryParam(value="recursive") Boolean recursiveForSwagger) throws Exception {
        String ids = this.servletRequest.getParameter("ids");
        BiBus bus = this.getNewBiBus();
        if (ids == null) {
            throw new RestException(400, new ContentMessage(MessageKeys.MISSING_FIELD, "ids"));
        }
        JsonArray objects = new JsonArray();
        for (String id : ids.split(",")) {
            objects.add((Object)PathBuilder.fromId(id));
        }
        Long count = (Long)bus.contentManager.delete((List)objects, (Map)this.buildDeleteOptions());
        return this.wrapCount(count);
    }

    @PUT
    @Path(value="/{id:[ix.].+?}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update or move object")
    public Response updateObject(@ApiParam(value="Object definition.<p>For update, specifies properties to update. Must spicify the type of the object that's being updated.<p>For move request, should only include parent id.") JsonObject data, @PathParam(value="id") String storeID, @QueryParam(value="updateAction") String updateActionForSwagger) throws Exception {
        JsonArray parent = data.getArray("parent");
        if (parent == null) {
            this.updateObjectProperties(storeID, data);
        } else {
            this.validateParentForMove(parent);
            this.moveObject(storeID, PathBuilder.fromId(((JsonObject)parent.get(0)).getString("id")), data);
        }
        return this.noContent();
    }

    private Boolean validateParentForMove(JsonArray parent) {
        if (parent.size() == 1 && ((JsonObject)parent.get(0)).containsKey((Object)"id") && ((JsonObject)parent.get(0)).size() == 1) {
            return true;
        }
        throw new RestException(400, new ContentMessage(MessageKeys.BAD_REQUEST_CONTENT), (Throwable)new ContentException("Properties other than a single 'id' under parent is not supported for this request."));
    }

    private void moveObject(String storeID, String targetParent, JsonObject data) throws Exception {
        BiBus biBus = super.getNewBiBus();
        JsonArray fromObjectArray = new JsonArray();
        fromObjectArray.add((Object)PathBuilder.fromId(storeID));
        this.validateMoveProperties(data);
        if (data.containsKey((Object)"defaultName")) {
            JsonArray newNameArray = new JsonArray();
            newNameArray.add((Object)data.getString("defaultName"));
            biBus.contentManager.moveRename((List)fromObjectArray, targetParent, (List)newNameArray, (Map)this.buildMoveOptions());
        } else {
            biBus.contentManager.move((List)fromObjectArray, targetParent, (Map)this.buildMoveOptions());
        }
    }

    private void validateMoveProperties(JsonObject data) {
        this.validateAcceptedProperties(data, "defaultName", "parent");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id:[ix.].+?}/items")
    @ApiOperation(value="Add a new or create a copy of existing object")
    public Response addFolderChildren(@ApiParam(value="Object definition.<p> For add request, 'type' property is required.<p>For copy request can specify optional 'defaultName' (and only it).") JsonObject data, @PathParam(value="id") String parentId, @ApiParam(value="a comma separated list of object ids to copy. Required for copy. Must not be set for add.") @QueryParam(value="source") String sourceForSwagger, @QueryParam(value="recursive") Boolean recursiveForSwagger, @QueryParam(value="updateAction") String updateActionForSwagger) throws Exception {
        String[] sourceIDs = this.getArrayQueryParam("source");
        List<?> items = null;
        items = sourceIDs != null ? this.copyObject(parentId, sourceIDs, data) : this.addObject(parentId, null, data);
        return this.wrapPostResult(items);
    }

    private List<?> copyObject(String parentId, String[] sourceIDs, JsonObject data) throws Exception {
        BiBus biBus = super.getNewBiBus();
        String targetParent = PathBuilder.fromId(parentId);
        JsonArray fromObjectArray = new JsonArray();
        for (String id : sourceIDs) {
            fromObjectArray.add((Object)PathBuilder.fromId(id));
        }
        if (data != null && data.containsKey((Object)"defaultName")) {
            if (sourceIDs.length != 1) {
                throw new RestException(400, new ContentMessage(MessageKeys.BAD_REQUEST_CONTENT), (Throwable)new ContentException("Bulk copy/rename is unsupported. Request payload must be empty when multiple source objects are specified"));
            }
            this.validateCopyProperties(data);
            JsonArray newNameArray = new JsonArray();
            newNameArray.add((Object)data.getString("defaultName"));
            return biBus.contentManager.copyRename((List)fromObjectArray, targetParent, (List)newNameArray, (Map)this.buildCopyOptions());
        }
        return biBus.contentManager.copy((List)fromObjectArray, targetParent, (Map)this.buildCopyOptions());
    }

    private void validateCopyProperties(JsonObject data) {
        this.validateAcceptedProperties(data, "defaultName");
    }

    private void validateAcceptedProperties(JsonObject data, String ... acceptedProperties) {
        HashSet properties = new HashSet(data.keySet());
        HashSet<String> expectedProperties = new HashSet<String>(Arrays.asList(acceptedProperties));
        properties.removeAll(expectedProperties);
        if (!properties.isEmpty()) {
            throw new RestException(400, new ContentMessage(MessageKeys.BAD_REQUEST_CONTENT), (Throwable)new ContentException("Properties " + String.join((CharSequence)", ", properties) + " are not supported for this request."));
        }
    }

    @Path(value="/{id:[ix.].+?}/{subResource:models|configuration|drill_paths}")
    public PackageResource packageResource(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields, @QueryParam(value="last") Boolean last, @QueryParam(value="navFilter") Boolean navfilter) {
        return new PackageResource(this.servletRequest, this.servletResponse, this.request, this.uriInfo);
    }

    @Path(value="/{id:[ix.].+?}/{subResource:histories|history_details}")
    public HistoryResource historyResource(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields, @QueryParam(value="status") String status, @QueryParam(value="updateAction") String updateAction) {
        return new HistoryResource(this.servletRequest, this.servletResponse, this.request, this.uriInfo);
    }

    @Path(value="/{id:[ix.].+?}/{subResource:versions|outputs|data|default_output}")
    public OutputResource outputResource(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields) {
        return new OutputResource(this.servletRequest, this.servletResponse, this.request, this.uriInfo);
    }
}

