/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.cognos.content.core.ContentMessage;
import com.ibm.bi.cognos.content.core.MessageKeys;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.apps.resources.BaseResource;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@Path(value="/path")
@Api(value="path")
public class PathResource
extends BaseResource {
    private static String CHARSET = "UTF-8";
    @Context
    private UriInfo uriInfo;

    public PathResource() {
    }

    public PathResource(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Return properties of object specified by name-based path.")
    public Response getByPathParameter(@QueryParam(value="path") String path, @QueryParam(value="fields") String fields) {
        return this.getPathResponse(this.buildSearchPathFromPathParm(path));
    }

    @GET
    @Path(value="/{path:(\\.public_folders|\\.my_folders|\\.library).*}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated - do not use")
    @Deprecated
    public Response getByPath(@ApiParam(value="Object path. First path segment must be a predifiened alias: .public_folders, .my_folders, etc. Following segments should be an URL-encoded name of ancestor object", required=true) @PathParam(value="path") String pathforSwagger, @QueryParam(value="fields") String fields) throws Exception {
        this.servletResponse.setHeader("Warning", "299 - \"Deprecated API : use /bi/v1/path?path={urlencodedpath}\"");
        return this.getPathResponse(this.buildSearchPathFromPathInfo());
    }

    protected Response getPathResponse(String searchPath) throws RestException {
        JsonArray props = new JsonArray();
        props.add((Object)"id");
        try {
            Map data = this.queryMultipleCache(searchPath, props, null);
            JsonArray result = this.extractQueryMultipleCacheResults(data);
            if (result.size() > 0) {
                return Response.status((Response.Status)Response.Status.MOVED_PERMANENTLY).header("Location", (Object)this.buildLocationURL(result)).entity((Object)result).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            throw new RestException(Response.Status.BAD_REQUEST.getStatusCode(), new ContentMessage(MessageKeys.INVALID_PATH, this.uriInfo.getPath()));
        }
    }

    String buildLocationURL(JsonArray result) {
        StringBuilder sb = new StringBuilder();
        sb.append(result.getObject(0).getObject("_meta").getObject("links").getObject("self").getString("url"));
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        if (queryParams != null && !queryParams.isEmpty()) {
            sb.append("?");
            queryParams.forEach((key, values) -> {
                if (!this.skipKey((String)key)) {
                    for (String val : values) {
                        String encVal = null;
                        try {
                            encVal = URLEncoder.encode(val, CHARSET).replaceAll("\\+", "%20");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RestException(Response.Status.BAD_REQUEST.getStatusCode(), new ContentMessage(MessageKeys.INVALID_PATH, CHARSET + " is unknown " + val));
                        }
                        sb.append((String)key).append("=").append(encVal).append("&");
                    }
                }
            });
            sb.deleteCharAt(sb.length() - 1);
        }
        return this.buildLocationURI(sb.toString());
    }

    protected boolean skipKey(String key) {
        return "path".equalsIgnoreCase(key);
    }

    String buildSearchPathFromPathInfo() throws RestException {
        PathBuilder pb = new PathBuilder();
        List pathParts = this.uriInfo.getPathSegments(false);
        for (int i = 0; i < pathParts.size(); ++i) {
            PathSegment segment = (PathSegment)pathParts.get(i);
            if (i == 0) continue;
            if (i == 1) {
                pb.id(segment.getPath());
                continue;
            }
            String decoded = PathResource.urlDecode(segment.getPath());
            if (!StringUtils.isNotEmpty((String)decoded)) continue;
            pb.children("*").name(decoded);
        }
        return pb.toString();
    }

    String buildSearchPathFromPathParm(String path) throws RestException {
        PathBuilder pb = new PathBuilder();
        String[] pathParts = path.split("/");
        boolean first = true;
        for (int i = 0; i < pathParts.length; ++i) {
            String part = pathParts[i];
            if (!StringUtils.isNotEmpty((String)part)) continue;
            if (first) {
                pb.id(part);
                first = false;
                continue;
            }
            String decoded = PathResource.urlDecode(part);
            if (!StringUtils.isNotEmpty((String)decoded)) continue;
            pb.children("*").name(decoded);
        }
        return pb.toString();
    }

    private static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RestException(Response.Status.BAD_REQUEST.getStatusCode(), new ContentMessage(MessageKeys.INVALID_PATH, CHARSET + " is unknown " + s));
        }
    }
}

