/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources;

import com.ibm.bi.content.apps.resources.PathResource;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/search_path")
@Api(value="search_path")
public class SearchPathResource
extends PathResource {
    private static Pattern namePredicate = Pattern.compile("@name=('[^']*')|(\"[^\"]*\")");

    public SearchPathResource() {
    }

    SearchPathResource(UriInfo uriInfo) {
        super(uriInfo);
    }

    @Override
    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Return properties of object specified by search path.")
    public Response getByPathParameter(@QueryParam(value="searchPath") String searchPath, @QueryParam(value="fields") String fields) {
        if (this.isValid(searchPath)) {
            return this.getPathResponse(searchPath);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Override
    protected boolean skipKey(String key) {
        return "searchPath".equalsIgnoreCase(key) || super.skipKey(key);
    }

    boolean isValid(String searchPath) {
        String newPath = namePredicate.matcher(searchPath).replaceAll("");
        if (newPath.contains("//")) {
            return false;
        }
        return !searchPath.endsWith("/*");
    }
}

