/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.filters;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;

public class ContentMetrics {
    private Timer requestTimer = new Timer((Reservoir)new SlidingTimeWindowArrayReservoir(30L, TimeUnit.SECONDS));
    private Counter totalRequests = new Counter();
    private Counter failedRequests = new Counter();

    public void incFailure() {
        this.failedRequests.inc();
    }

    public void incRequest() {
        this.totalRequests.inc();
    }

    public Timer.Context startTimer() {
        return this.requestTimer.time();
    }

    public double getMeanRequestTimeinSeconds() {
        if (this.requestTimer != null) {
            return this.requestTimer.getSnapshot().getMean() / 1.0E9;
        }
        return 0.0;
    }

    public long getTotalRequests() {
        return this.totalRequests.getCount();
    }

    public long getFailedRequests() {
        return this.failedRequests.getCount();
    }

    public void resetCounters() {
        this.totalRequests.dec(this.totalRequests.getCount());
        this.failedRequests.dec(this.failedRequests.getCount());
    }
}

