/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.filters;

import com.codahale.metrics.Timer;
import com.ibm.bi.content.apps.resources.filters.ContentMetrics;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletResponse;

@WebFilter(urlPatterns={"/*"}, dispatcherTypes={DispatcherType.FORWARD})
public class ContentMetricsFilter
implements Filter {
    private ContentMetrics contentRequestsMetrics;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.contentRequestsMetrics = (ContentMetrics)filterConfig.getServletContext().getAttribute("ContentServiceMetrics");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer.Context timer = this.updateRequestMetrics();
        chain.doFilter(request, response);
        this.updateResponseMetrics((HttpServletResponse)response, timer);
    }

    protected Timer.Context updateRequestMetrics() {
        this.contentRequestsMetrics.incRequest();
        return this.contentRequestsMetrics.startTimer();
    }

    protected void updateResponseMetrics(HttpServletResponse response, Timer.Context timer) {
        timer.stop();
        if (response.getStatus() >= 500) {
            this.contentRequestsMetrics.incFailure();
        }
    }

    public void destroy() {
    }
}

