/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.filters;

import com.ibm.bi.platform.commons.crypto.CAMCryptoException;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/*"}, dispatcherTypes={DispatcherType.FORWARD})
public class TrustVerificationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TrustVerificationFilter.class);
    public static final String TRUSTED_SERVICE_ID = "TrustVerificationFilter.ServiceID";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.verifyTrust((HttpServletRequest)request);
        filterChain.doFilter(request, response);
    }

    private void verifyTrust(HttpServletRequest request) {
        request.setAttribute(TRUSTED_SERVICE_ID, null);
        String token = request.getHeader("X-CA-Authorization");
        if (StringUtils.isEmpty((String)token)) {
            return;
        }
        String serviceID = this.getServiceIDAndVerifyToken(token);
        if (serviceID == null) {
            throw new WebApplicationException(Response.status((int)400).entity((Object)"bad trust token").build());
        }
        request.setAttribute(TRUSTED_SERVICE_ID, (Object)serviceID);
    }

    protected String getServiceIDAndVerifyToken(String token) {
        try {
            return JCAMCrypto.createTrustedRequestSession().getServiceIDAndVerifyToken(token);
        }
        catch (CAMCryptoException e) {
            LOG.info("problem verifying trust token", (Throwable)e);
            return null;
        }
    }

    public static String isFromTrustedService(HttpServletRequest request) {
        return (String)request.getAttribute(TRUSTED_SERVICE_ID);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

