/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.subresources;

import com.ibm.bi.content.apps.resources.ObjectResource;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.ContentManager;
import com.wordnik.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Api(hidden=true)
public class HistoryResource
extends ObjectResource {
    public HistoryResource(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Request request, UriInfo uriInfo) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSubResource(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields, @QueryParam(value="status") String status) throws Exception {
        switch (subResource) {
            case "histories": {
                return this.getHistories(storeID);
            }
            case "history_details": {
                return this.getHistoryDetails(storeID);
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Response getHistories(String storeID) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("history");
        Response result = this.checkPreconditions(path.toString());
        if (result != null) {
            return result;
        }
        String[] statusParams = this.getArrayQueryParam("status");
        if (statusParams != null) {
            path.oneOf("@status", statusParams);
        }
        FieldsQueryParam fields = new FieldsQueryParam(this.getQueryParam("fields"), "status,requestedExecutionTime,actualExecutionTime,actualCompletionTime", true);
        boolean hasOutput = false;
        if (fields.getProperties().contains((Object)"output")) {
            fields.getProperties().remove((Object)"output");
            hasOutput = true;
        }
        JsonObject options = this.buildQueryOptions(fields, false);
        if (hasOutput) {
            List history = this.query(path.toString(), (List)fields.getProperties(), (Map)options);
            if (!history.isEmpty()) {
                List detailsMap = this.queryHistoryDetailReportService(storeID);
                this.queryAndAppendOutput(storeID, history, detailsMap);
            }
            return this.wrapResult(history).build();
        }
        Map history = this.queryMultipleCache(path.toString(), fields.getProperties(), options);
        return this.wrapResult(history).build();
    }

    public Response getHistoryDetails(String storeID) throws Exception {
        String searchPath = new PathBuilder().id(storeID).children("*").toString();
        Response result = this.checkPreconditions(searchPath);
        if (result != null) {
            return result;
        }
        Map data = this.queryMultipleCache(searchPath, new JsonArray(new Object[]{"storeID"}), null);
        Object results = this.extractQueryMultipleCacheResults(data);
        if (results.size() == 0) {
            return this.wrapResult(data).build();
        }
        EntityTag etag = this.getEtagFromCacheValidator(data);
        results = this.getNewBiBus().contentManager.queryMultiple((List)this.createDetailsQuery(storeID, (List)results));
        data = this.createDetailsObject((List)results);
        Response.ResponseBuilder builder = this.buildResponse(data, true);
        if (etag != null) {
            builder = builder.tag(etag);
        }
        return builder.build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addHistory(JsonObject data, @PathParam(value="id") String parentId, @QueryParam(value="updateAction") String updateAction) throws Exception {
        List<?> items = this.addObject(parentId, "history", data);
        return this.wrapPostResult(items);
    }

    protected List query(String searchPath, List properties, Map options) throws Exception {
        BiBus biBus = this.getNewBiBus();
        return biBus.contentManager.query(searchPath, properties, null, options);
    }

    List queryHistoryDetailReportService(String storeID) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("history").children("historyDetailReportService");
        FieldsQueryParam fields = new FieldsQueryParam("output,parent");
        JsonObject options = this.buildQueryOptions(fields, false);
        return this.query(path.toString(), (List)fields.getProperties(), (Map)options);
    }

    void queryAndAppendOutput(String storeID, List history, List details) throws Exception {
        for (Object oDetail : details) {
            JsonObject detail = (JsonObject)oDetail;
            JsonObject parent = detail.getArray("parent").getObject(0);
            String id = parent.getString("id");
            JsonArray aOutput = detail.getArray("output");
            if (aOutput == null || aOutput.isEmpty()) continue;
            JsonObject output = aOutput.getObject(0);
            HistoryResource.appendDetailsToID(id, history, output);
        }
    }

    private static void appendDetailsToID(String id, List history, JsonObject output) {
        for (Object oHistory : history) {
            JsonObject h = (JsonObject)oHistory;
            if (!h.getString("id").equals(id)) continue;
            h.put("output", (Object)output);
        }
    }

    JsonObject createDetailsObject(List replies) throws Exception {
        JsonObject result = new JsonObject();
        JsonObject data = new JsonObject();
        result.put("data", (Object)data);
        JsonArray messages = new JsonArray();
        JsonArray saveToCloudLocations = new JsonArray();
        boolean isSaveToCloudHistories = false;
        for (Object reply : replies) {
            for (JsonObject obj : (List)((Map)reply).get("queryResult")) {
                String detailType;
                String type = obj.getString("type");
                if (type.equals("historyDetailRequestArguments")) {
                    JsonObject args = new JsonObject();
                    data.put("requestArguments", (Object)args);
                    args.put("options", (Object)obj.getArray("options"));
                    if (!obj.containsKey((Object)"parameters")) continue;
                    args.put("parameters", obj.get("parameters"));
                    continue;
                }
                if (type.equals("historyDetailAgentService") || type.equals("historyDetailReportService")) {
                    data.put("output", obj.get("output"));
                    continue;
                }
                if (type.equals("deploymentDetail")) {
                    String detailTime = obj.getString("detailTime");
                    for (JsonObject fault : (List)obj.get("message")) {
                        JsonObject message = new JsonObject();
                        message.put("severity", fault.get("severity"));
                        message.put("detailTime", (Object)detailTime);
                        StringBuilder buf = new StringBuilder();
                        String sep = "";
                        for (JsonObject msg : (List)fault.get("message")) {
                            buf.append(sep).append(msg.getString("message"));
                            sep = " ";
                        }
                        message.put("detail", (Object)buf.toString());
                        messages.add((Object)message);
                    }
                    continue;
                }
                if (type.equals("historyDetail") || type.equals("historyDetailMoserService")) {
                    JsonObject message = new JsonObject();
                    for (String prop : new String[]{"detail", "severity", "detailTime"}) {
                        message.put(prop, obj.get(prop));
                    }
                    messages.add((Object)message);
                    continue;
                }
                if (!type.equals("genericHistoryDetail") || !(detailType = obj.getString("detailType")).equals("saveToCloudLocationDetail")) continue;
                isSaveToCloudHistories = true;
                JsonObject info = JsonObject.parseString((String)obj.getString("info"), (boolean)true);
                saveToCloudLocations.add((Object)info.getArray("uploaded"));
            }
        }
        data.put("messages", (Object)(messages.size() == 0 ? null : messages));
        if (isSaveToCloudHistories) {
            data.put("saveToCloudLocations", (Object)(saveToCloudLocations.size() == 0 ? null : saveToCloudLocations));
        }
        return result;
    }

    JsonArray createDetailsQuery(String historyId, List results) throws Exception {
        PathBuilder path;
        JsonArray props;
        JsonArray requests = new JsonArray();
        String requestArgsId = null;
        boolean isDeployment = false;
        BiBus biBus = this.getNewBiBus();
        ContentManager cm = biBus.contentManager;
        boolean hasHistoryDetails = false;
        for (Object item : results) {
            String id;
            JsonObject object = (JsonObject)item;
            String type = object.getString("type");
            if (type.equals("deploymentDetail")) {
                isDeployment = true;
                continue;
            }
            if (type.equals("historyDetailAgentService") || type.equals("historyDetailReportService")) {
                id = object.getString("id");
                requests.add((Object)cm.queryRequest(PathBuilder.fromId(id), (List)new JsonArray(new Object[]{"output"}), null, null));
                continue;
            }
            if (type.equals("historyDetailRequestArguments")) {
                requestArgsId = object.getString("id");
                continue;
            }
            if (type.equals("historyDetail") || type.equals("historyDetailMoserService")) {
                hasHistoryDetails = true;
                continue;
            }
            if (!type.equals("genericHistoryDetail")) continue;
            id = object.getString("id");
            JsonArray props2 = new JsonArray(new Object[]{"detailType", "info"});
            requests.add((Object)cm.queryRequest(PathBuilder.fromId(id), (List)props2, null, null));
        }
        if (requestArgsId != null) {
            props = new JsonArray(new Object[]{"options"});
            if (!isDeployment) {
                props.add((Object)"parameters");
            }
            requests.add((Object)cm.queryRequest(PathBuilder.fromId(requestArgsId), (List)props, null, null));
        }
        if (isDeployment) {
            props = new JsonArray(new Object[]{"message", "deployedObjectClass", "detailTime"});
            path = new PathBuilder().id(historyId).descendants("deploymentDetail").equals("@hasMessage", "true");
            requests.add((Object)cm.queryRequest(path.toString(), (List)props, null, null));
        }
        if (hasHistoryDetails) {
            props = new JsonArray(new Object[]{"detail", "severity", "detailTime"});
            path = new PathBuilder().id(historyId).children("*").oneOf("@objectClass", "historyDetail", "historyDetailMoserService").isNotNull("detail");
            requests.add((Object)cm.queryRequest(path.toString(), (List)props, null, null));
        }
        return requests;
    }
}

