/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.subresources;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import com.ibm.bi.content.apps.resources.ObjectResource;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.soap.services.MimeAttachment;
import com.ibm.bi.soap.services.SoapException;
import com.wordnik.swagger.annotations.Api;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Api(hidden=true)
public class OutputResource
extends ObjectResource {
    private static final String DEFAULT_PROPS = "burstKey,dataType,dataPathInfo,format,locale";

    public OutputResource(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Request request, UriInfo uriInfo) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getResource(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields) throws Exception {
        switch (subResource) {
            case "versions": {
                return this.getVersions(storeID);
            }
            case "outputs": {
                return this.getOutputs(storeID, false);
            }
            case "default_output": {
                return this.getOutputs(storeID, true);
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Response getVersions(String storeID) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("reportVersion").allPermissions("read");
        return this.getCMObjects(path.toString(), true, "modificationTime");
    }

    public Response getOutputs(String storeID, boolean getDefault) throws Exception {
        String path = !getDefault ? new PathBuilder().id(storeID).children("output").allPermissions("read").toString() : new PathBuilder().defaultOutput(storeID).toString();
        Response result = this.checkPreconditions(path);
        if (result != null) {
            return result;
        }
        FieldsQueryParam fields = new FieldsQueryParam(this.getQueryParam("fields"), DEFAULT_PROPS);
        JsonObject options = this.buildQueryOptions(fields, this.getBooleanQueryParam("schemaInfo"));
        Map data = this.queryMultipleCache(path, fields.getProperties(), options);
        this.postProcessOutputQuery(data);
        return this.wrapResult(data).build();
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response addData(@PathParam(value="id") String storeID, @HeaderParam(value="Content-Type") MediaType contentType, InputStream incoming) throws SoapException {
        try {
            this.tryAddData(storeID, incoming, contentType);
        }
        catch (SoapException e) {
            if (this.isNotFoundException(e)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
        catch (RestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentException((Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)storeID).build();
    }

    private void tryAddData(String storeID, InputStream incoming, MediaType contentType) throws Exception {
        JsonObject obj = new JsonObject();
        obj.put("type", (Object)"output");
        obj.put("data", (Object)new MimeAttachment(incoming, contentType));
        this.updateObjectProperties(storeID, obj);
    }

    private boolean isNotFoundException(SoapException e) {
        return "cmEmptySelection".equals(e.getErrorCode());
    }

    void postProcessOutputQuery(Map data) {
        StringBuilder url = new StringBuilder(this.buildBaseURL());
        url.append("/disp");
        int len = url.length();
        for (JsonObject reply : (List)data.get("replies")) {
            for (JsonObject item : (List)reply.get("queryResult")) {
                JsonObject links = item.getObject("_meta").getObject("links");
                JsonObject self = (JsonObject)links.remove((Object)"self");
                self.put("mimeType", (Object)item.getString("dataType"));
                url.setLength(len);
                url.append(item.getString("dataPathInfo"));
                self.put("url", (Object)url.toString());
                links.put("content", (Object)self);
                item.remove((Object)"dataType");
                item.remove((Object)"dataPathInfo");
            }
        }
    }
}

