/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.resources.subresources;

import com.ibm.bi.content.apps.resources.ObjectResource;
import com.ibm.bi.content.apps.utils.FieldsQueryParam;
import com.ibm.bi.content.apps.utils.PathBuilder;
import com.ibm.bi.json.JsonObject;
import com.wordnik.swagger.annotations.Api;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Api(hidden=true)
public class PackageResource
extends ObjectResource {
    public PackageResource(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Request request, UriInfo uriInfo) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getResponse(@PathParam(value="id") String storeID, @PathParam(value="subResource") String subResource, @QueryParam(value="fields") FieldsQueryParam fields, @QueryParam(value="last") Boolean last, @QueryParam(value="navFilter") Boolean navfilter) throws Exception {
        switch (subResource) {
            case "models": {
                return this.getModels(storeID, fields, last);
            }
            case "configuration": {
                return this.getPackageConfiguration(storeID, fields);
            }
            case "drill_paths": {
                return this.getPackageDrillPaths(storeID, fields, navfilter);
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public Response getModels(String storeID, FieldsQueryParam fields, Boolean last) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("model");
        if (this.getBooleanQueryParam("last")) {
            path.last();
        }
        return this.getCMObjects(path.toString());
    }

    public Response getPackageConfiguration(String storeID, FieldsQueryParam fields) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("packageConfiguration");
        return this.getCMObjects(path.toString());
    }

    public Response getPackageDrillPaths(String storeID, FieldsQueryParam fields, Boolean navfilter) throws Exception {
        PathBuilder path = new PathBuilder().id(storeID).children("drillPath");
        if (this.getBooleanQueryParam("nav_filter")) {
            path.navigationFilter();
        }
        return this.getCMObjects(path.toString());
    }

    public Response addModel(JsonObject data, String parentId, String updateAction) throws Exception {
        List<?> items = this.addObject(parentId, "model", data);
        return this.wrapPostResult(items);
    }
}

