/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.soap_handlers;

import com.ibm.bi.content.apps.utils.CryptoHelper;
import com.ibm.bi.soap.schema.Property;
import com.ibm.bi.soap.schema.SerializationContext;
import com.ibm.bi.soap.schema.handlers.DefaultPropertyHandler;

public class EncryptingPropHandler
extends DefaultPropertyHandler {
    CryptoHelper crypto;

    public EncryptingPropHandler() {
        this(new CryptoHelper());
    }

    public EncryptingPropHandler(CryptoHelper cryptoHelper) {
        this.crypto = cryptoHelper;
    }

    public void serialize(SerializationContext sc, Property prop, Object value) {
        if (sc.json.isNull(value)) {
            super.serialize(sc, prop, value);
            return;
        }
        String propValue = sc.json.toString(value).trim();
        if (propValue.startsWith("<credential>") && propValue.indexOf("<encryptedValue>") == -1 || propValue.startsWith("<credentials>")) {
            StringBuilder buf = new StringBuilder(256);
            buf.append("<credential><encryptedValue>").append(this.crypto.encryptString(propValue)).append("</encryptedValue></credential>");
            value = sc.json.createString(propValue);
        }
        super.serialize(sc, prop, value);
    }
}

