/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.utils;

import com.ibm.bi.cognos.content.core.exceptions.ContentException;
import com.ibm.bi.config.ConfigurationPropertyFactory;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.netflix.config.DynamicStringProperty;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmRest
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(CmRest.class);
    private RESTClient rest;
    private String cmUrl;

    public CmRest(HttpServletRequest servletRequest) throws ContentException {
        this.rest = RESTClientFactory.getInstance().getClient(servletRequest);
        this.cmUrl = CmRest.getCmRestUrl();
    }

    public int validateEtag(String path, String etag) throws ContentException {
        StringBuilder buf = new StringBuilder(path.length() + this.cmUrl.length() + 10);
        buf.append(this.cmUrl).append("tags/");
        try {
            buf.append(URLEncoder.encode(path, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ContentException((Throwable)e);
        }
        this.setEtag(etag);
        return this.getResource(buf.toString());
    }

    public int getObjectProperty(String id, String property) throws ContentException {
        StringBuilder buf = new StringBuilder(id.length() + this.cmUrl.length() + 10);
        buf.append(this.cmUrl).append("objects/").append(id).append("/").append(property);
        return this.getResource(buf.toString());
    }

    private int getResource(String url) throws ContentException {
        try {
            logger.debug("Sending CM REST request: " + url);
            return this.rest.getResource(url);
        }
        catch (IOException ioe) {
            throw new ContentException((Throwable)ioe);
        }
    }

    private static String getCmRestUrl() throws ContentException {
        DynamicStringProperty cmProp = ConfigurationPropertyFactory.getInstance().getStringProperty("contentManager", null);
        String value = cmProp.get();
        if (value == null) {
            throw new ContentException("contentManager configuration parameter is null");
        }
        if (!value.endsWith("/servlet")) {
            throw new ContentException("unexpect format of contentManager URL: " + value);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(value.substring(0, value.length() - 7));
        buf.append("cm/1.0/");
        return buf.toString();
    }

    public void setEtag(String etag) {
        StringBuilder buf = new StringBuilder(50);
        buf.append('\"').append(etag).append('\"');
        this.rest.setRequestHeader("If-None-Match", buf.toString());
    }

    public String getResponseHeader(String name) {
        return this.rest.getResponseHeader(name);
    }

    public String getResponseAsString() throws ContentException {
        try {
            return IOUtils.toString((InputStream)this.rest.getResponseStream());
        }
        catch (IOException ioe) {
            throw new ContentException((Throwable)ioe);
        }
    }

    public JsonObject getResponseAsJsonObject() throws ContentException {
        try {
            return this.rest.getResponseAsJsonObject();
        }
        catch (IOException ioe) {
            throw new ContentException((Throwable)ioe);
        }
    }

    public JsonArray getResponseAsJsonArray() throws ContentException {
        try {
            return this.rest.getResponseAsJsonArray();
        }
        catch (IOException ioe) {
            throw new ContentException((Throwable)ioe);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.rest);
    }
}

