/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.content.apps.utils;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.ibm.bi.cognos.content.core.exceptions.RestException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoHelper {
    private static final Logger logger = LoggerFactory.getLogger(CryptoHelper.class);
    private static volatile CAMFactory camFactory = null;

    public static void setCamFactory(CAMFactory test) {
        camFactory = test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CAMFactory getCamFactory() {
        if (camFactory != null) return camFactory;
        Class<CryptoHelper> clazz = CryptoHelper.class;
        synchronized (CryptoHelper.class) {
            try {
                if (camFactory != null) return camFactory;
                camFactory = new CAMFactory("CS-REST");
            }
            catch (CAMCryptoException e) {
                logger.error("Error initializing crypto library", (Throwable)e);
                throw new RestException((Throwable)e);
            }
            return camFactory;
        }
    }

    public String encryptString(String data) {
        try {
            EncryptingSession es = this.getCamFactory().createEncryptingSession();
            byte[] encrypted = es.encryptData(data.getBytes("utf-8"));
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            logger.error("Unable to encrypt data", (Throwable)e);
            throw new RestException((Throwable)e);
        }
    }
}

